/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.testing;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.atlanmod.commons.reflect.MoreReflection;

public class EqualsVerifier<T> {
    private final Class<T> type;
    private Object[] arguments;
    private Object[] variants;

    EqualsVerifier(Class<T> type) {
        this.type = type;
    }

    public EqualsVerifier<T> withArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public EqualsVerifier<T> andVariants(Object ... variants) {
        this.variants = variants;
        return this;
    }

    public void check() {
        this.checkArguments(this.arguments, this.variants);
        Class[] argumentTypes = EqualsVerifier.mapToClasses(this.arguments);
        Function instantiator = MoreReflection.getInstantiator(this.type, (Class[])argumentTypes);
        Object[] freaks = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            Object[] variation = Arrays.copyOf(this.arguments, this.arguments.length);
            variation[i] = this.variants[i];
            freaks[i] = instantiator.apply(variation);
        }
        Object one = instantiator.apply(this.arguments);
        Object clone = instantiator.apply(this.arguments);
        EqualsVerifier.assertIsEqualsToSelf(one);
        EqualsVerifier.assertIsEqual(one, clone);
        EqualsVerifier.assertNotEqualToNull(one);
        for (Object each : freaks) {
            EqualsVerifier.assertNotEqual(one, each);
        }
    }

    private void checkArguments(Object[] arguments, Object[] variants) {
        int length = arguments.length;
        if (variants.length != length) {
            throw new IllegalArgumentException("Argument arrays must have the same length");
        }
        for (int i = 0; i < length; ++i) {
            if (!arguments[i].equals(variants[i])) continue;
            throw new IllegalArgumentException("Argument arrays must have different elements");
        }
    }

    private static Class[] mapToClasses(Object[] objects) {
        return (Class[])Stream.of(objects).map(Object::getClass).toArray(Class[]::new);
    }

    public static void assertIsEqual(Object one, Object other) {
        if (!one.equals(other)) {
            throw new AssertionError((Object)"Expecting objects to be equal");
        }
        if (!other.equals(one)) {
            throw new AssertionError((Object)"Equals is supposed to be symmetric");
        }
        if (one.hashCode() != other.hashCode()) {
            throw new AssertionError((Object)"Equal objects must have the same hash code");
        }
    }

    public static void assertNotEqual(Object one, Object other) {
        if (one.equals(other)) {
            throw new AssertionError((Object)"Expecting objects NOT to be equal");
        }
    }

    public static void assertNotEqualToNull(Object one) {
        if (one.equals(null)) {
            throw new AssertionError((Object)"Non-null objets should not be equal to null");
        }
    }

    public static void assertIsEqualsToSelf(Object one) {
        if (!one.equals(one)) {
            throw new AssertionError((Object)"Object should be equal to itself");
        }
    }
}

