/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.testing;

import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.predicate.BooleanPredicate;
import org.atlanmod.commons.predicate.IntPredicate;
import org.atlanmod.commons.predicate.LongPredicate;
import org.atlanmod.commons.predicate.ObjectPredicate;
import org.atlanmod.commons.predicate.PredicateContext;
import org.atlanmod.commons.predicate.StringPredicate;

@Static
@ParametersAreNonnullByDefault
public class Assertions {
    private static final PredicateContext CONTEXT = new AssertionContext();

    private Assertions() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static BooleanPredicate assertThat(boolean expression) {
        return new BooleanPredicate(CONTEXT, expression);
    }

    public static IntPredicate assertThat(int expression) {
        return new IntPredicate(CONTEXT, expression);
    }

    public static LongPredicate assertThat(long expression) {
        return new LongPredicate(CONTEXT, expression);
    }

    public static StringPredicate assertThat(String expression) {
        return new StringPredicate(CONTEXT, expression);
    }

    public static ObjectPredicate<ObjectPredicate, Object> assertThat(Object expression) {
        return new ObjectPredicate(CONTEXT, expression);
    }

    static class AssertionContext
    implements PredicateContext {
        AssertionContext() {
        }

        public void send(String pattern, Object ... args) {
            throw new AssertionError((Object)String.format(pattern, args));
        }
    }
}

