/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.testing;

import org.atlanmod.testing.Assertions;
import org.atlanmod.testing.TestUtility;
import org.junit.jupiter.api.Test;

class AssertionsTest {
    AssertionsTest() {
    }

    @Test
    void assertingATrueExpressionIsFalseRaises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((boolean)true).isFalse());
    }

    @Test
    void assertingAFalseExpressionIsTrueRaises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((boolean)false).isTrue());
    }

    @Test
    void correctBooleanAssertions_Raise_Nothing() {
        Assertions.assertThat((boolean)true).isTrue();
        Assertions.assertThat((boolean)false).isFalse();
    }

    @Test
    void assertingOneIsZeroRaises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)1).isZero());
    }

    @Test
    void asserting_11_IsBetween_0_and_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)11).isBetween(0, 10));
    }

    @Test
    void asserting_10_IsLessThan_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isLessThan(10));
    }

    @Test
    void asserting_10_IsLessThanOrEqualTo_9_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isLessThanOrEqualTo(9));
    }

    @Test
    void asserting_10_IsGreaterThan_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isGreaterThan(10));
    }

    @Test
    void asserting_10_IsGreaterThanOrEqualTo_11_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isGreaterThanOrEqualTo(11));
    }

    @Test
    void asserting_10_IsEqualTo_11_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isEqualTo(11));
    }

    @Test
    void asserting_10_IsDifferentFrom_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((int)10).isDifferentFrom(10));
    }

    @Test
    void correctIntAssertions_Raise_Nothing() {
        Assertions.assertThat((int)0).isZero();
        Assertions.assertThat((int)0).isBetween(0, 10);
        Assertions.assertThat((int)10).isBetween(0, 10);
        Assertions.assertThat((int)10).isLessThan(11);
        Assertions.assertThat((int)10).isLessThanOrEqualTo(10);
        Assertions.assertThat((int)10).isLessThanOrEqualTo(11);
        Assertions.assertThat((int)10).isGreaterThan(9);
        Assertions.assertThat((int)10).isGreaterThanOrEqualTo(10);
        Assertions.assertThat((int)10).isEqualTo(10);
        Assertions.assertThat((int)10).isDifferentFrom(11);
    }

    @Test
    void assertingOneLongIsZeroRaises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)1L).isZero());
    }

    @Test
    void asserting_11L_IsBetween_0_and_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)11L).isBetween(0L, 10L));
    }

    @Test
    void asserting_10L_IsLessThan_10_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isLessThan(10L));
    }

    @Test
    void asserting_10L_IsLessThanOrEqualTo_9L_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isLessThanOrEqualTo(9L));
    }

    @Test
    void asserting_10L_IsGreaterThan_10L_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isGreaterThan(10L));
    }

    @Test
    void asserting_10L_IsGreaterThanOrEqualTo_11L_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isGreaterThanOrEqualTo(11L));
    }

    @Test
    void asserting_10L_IsEqualTo_11L_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isEqualTo(11L));
    }

    @Test
    void asserting_10L_IsDifferentFrom_10L_Raises_AssertionError() {
        TestUtility.throwsAssertionError(() -> Assertions.assertThat((long)10L).isDifferentFrom(10L));
    }

    @Test
    void correctLongAssertions_Raise_Nothing() {
        Assertions.assertThat((long)0L).isZero();
        Assertions.assertThat((long)0L).isBetween(0L, 10L);
        Assertions.assertThat((long)10L).isBetween(0L, 10L);
        Assertions.assertThat((long)10L).isLessThan(11L);
        Assertions.assertThat((long)10L).isLessThanOrEqualTo(10L);
        Assertions.assertThat((long)10L).isLessThanOrEqualTo(11L);
        Assertions.assertThat((long)10L).isGreaterThan(9L);
        Assertions.assertThat((long)10L).isGreaterThanOrEqualTo(10L);
        Assertions.assertThat((long)10L).isEqualTo(10L);
        Assertions.assertThat((long)10L).isDifferentFrom(11L);
    }
}

