/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.util.Map;
import javax.inject.Singleton;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.Document;
import org.asciidoctor.maven.site.HeaderMetadata;

@Singleton
class SiteConverterDecorator {
    SiteConverterDecorator() {
    }

    Result process(Asciidoctor asciidoctor, String content, Options options) {
        Document document = asciidoctor.load(content, SiteConverterDecorator.headerProcessingMetadata(options));
        HeaderMetadata headerMetadata = HeaderMetadata.from((Document)document);
        String html = asciidoctor.convert(content, options);
        return new Result(headerMetadata, html);
    }

    private static Options headerProcessingMetadata(Options options) {
        Map optionsMap = options.map();
        OptionsBuilder builder = Options.builder();
        for (Map.Entry entry : optionsMap.entrySet()) {
            builder.option((String)entry.getKey(), entry.getValue());
        }
        builder.parseHeaderOnly(Boolean.TRUE.booleanValue());
        return builder.build();
    }

    final class Result {
        private final HeaderMetadata headerMetadata;
        private final String html;

        Result(HeaderMetadata headerMetadata, String html) {
            this.headerMetadata = headerMetadata;
            this.html = html;
        }

        HeaderMetadata getHeaderMetadata() {
            return this.headerMetadata;
        }

        String getHtml() {
            return this.html;
        }
    }
}

