/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.inject.Inject;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordsProcessors;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.asciidoctor.maven.site.HeadParser;
import org.asciidoctor.maven.site.LogHandlerFactory;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.asciidoctor.maven.site.SiteConversionConfigurationParser;
import org.asciidoctor.maven.site.SiteConverterDecorator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Parser.class, hint="asciidoc")
public class AsciidoctorConverterDoxiaParser
extends AbstractTextParser {
    static final String ROLE_HINT = "asciidoc";
    private static final Logger logger = LoggerFactory.getLogger(AsciidoctorConverterDoxiaParser.class);
    private final MavenProject mavenProject;
    private final SiteConversionConfigurationParser siteConfigParser;
    private final LogHandlerFactory logHandlerFactory;
    private final SiteConverterDecorator siteConverter;

    @Inject
    public AsciidoctorConverterDoxiaParser(MavenProject mavenProject, SiteConversionConfigurationParser siteConfigParser, LogHandlerFactory logHandlerFactory, SiteConverterDecorator siteConverter) {
        this.mavenProject = mavenProject;
        this.siteConfigParser = siteConfigParser;
        this.logHandlerFactory = logHandlerFactory;
        this.siteConverter = siteConverter;
    }

    public void parse(Reader reader, Sink sink, String reference) throws ParseException {
        String source;
        try {
            source = IOUtil.toString((Reader)reader);
            if (source == null) {
                source = "";
            }
        }
        catch (IOException ex) {
            logger.error("Could not read AsciiDoc source: {}", (Object)ex.getLocalizedMessage());
            return;
        }
        SiteConversionConfiguration conversionConfig = this.siteConfigParser.processAsciiDocConfig(this.mavenProject, ROLE_HINT);
        Xpp3Dom asciidocConfig = conversionConfig.getAsciidocConfig();
        File siteDirectory = conversionConfig.getSiteBaseDir();
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        for (String require : conversionConfig.getRequires()) {
            this.requireLibrary(asciidoctor, require);
        }
        LogHandler logHandler = this.logHandlerFactory.getConfiguration(asciidocConfig);
        MemoryLogHandler memoryLogHandler = this.logHandlerFactory.create(asciidoctor, siteDirectory, logger);
        SiteConverterDecorator.Result headerMetadata = this.siteConverter.process(asciidoctor, source, conversionConfig.getOptions());
        try {
            if (!memoryLogHandler.isEmpty()) {
                logger.info("Issues found in: {}", (Object)reference);
                if (logHandler.getOutputToConsole().booleanValue() && StringUtils.isNotBlank((CharSequence)reference)) {
                    memoryLogHandler.processAll();
                }
                new LogRecordsProcessors(logHandler, siteDirectory, arg_0 -> ((Logger)logger).error(arg_0)).processLogRecords(memoryLogHandler);
            }
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
        new HeadParser(sink).parse(headerMetadata.getHeaderMetadata());
        sink.rawText(headerMetadata.getHtml());
    }

    private void requireLibrary(Asciidoctor asciidoctor, String require) {
        if (!(require = require.trim()).isEmpty()) {
            try {
                asciidoctor.requireLibrary(new String[]{require});
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
    }
}

