/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.arquillian.ape.rdbms.core.DatabaseConfiguration;
import org.yaml.snakeyaml.Yaml;

public class WildflySwarmLoader {
    static final Map<String, String> DEFAULT_DRIVER_NAMES = new HashMap<String, String>();
    public static final String SWARM = "swarm";
    public static final String DATASOURCES = "datasources";
    public static final String DATA_SOURCES = "data-sources";
    public static final String JDBC_DRIVERS = "jdbc-drivers";
    private static final String JDBC_URI_PROPERTY_NAME = "connection-url";
    private static final String USERNAME_PROPERTY_NAME = "user-name";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private static final String DRIVER_PROPERTY_NAME = "driver-class-name";
    private static final String DRIVER_NAME = "driver-name";

    public static DatabaseConfiguration load(String name, String location) {
        DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration();
        InputStream configurationFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Wildfly Swarm configuration file %s not found in classpath.", location));
        }
        Yaml yaml = new Yaml();
        Map configuration = (Map)yaml.load(configurationFile);
        Map swarm = (Map)configuration.get(SWARM);
        Map datasources = Objects.requireNonNull((Map)swarm.get(DATASOURCES), String.format("Configuration file %s does not contain %s field", location, DATASOURCES));
        Map data_sources = Objects.requireNonNull((Map)datasources.get(DATA_SOURCES), String.format("Configuration file %s does not contain %s field", location, DATA_SOURCES));
        Map jdbc_drivers = (Map)datasources.get(JDBC_DRIVERS);
        String dataSourceName = WildflySwarmLoader.getDataSourceName(name, data_sources);
        Map dataSource = (Map)data_sources.get(dataSourceName);
        String driverName = (String)dataSource.get(DRIVER_NAME);
        databaseConfiguration.setJdbcDriver(WildflySwarmLoader.resolveJdbcDriver(driverName, jdbc_drivers));
        databaseConfiguration.setJdbc(URI.create((String)dataSource.get(JDBC_URI_PROPERTY_NAME)));
        databaseConfiguration.setUsername((String)dataSource.get(USERNAME_PROPERTY_NAME));
        databaseConfiguration.setPassword((String)dataSource.get(PASSWORD_PROPERTY_NAME));
        return databaseConfiguration;
    }

    private static Class<?> resolveJdbcDriver(String driverName, Map<String, Object> jdbc_drivers) {
        if (jdbc_drivers != null && jdbc_drivers.containsKey(driverName)) {
            Map jdbcDriver = (Map)jdbc_drivers.get(driverName);
            try {
                return Class.forName((String)jdbcDriver.get(DRIVER_PROPERTY_NAME));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (DEFAULT_DRIVER_NAMES.containsKey(driverName)) {
            try {
                return Class.forName(DEFAULT_DRIVER_NAMES.get(driverName));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(String.format("%s driver name could not be resolved to any class driver either in jdbc_drivers nor in default list %s", driverName, DEFAULT_DRIVER_NAMES));
    }

    private static String getDataSourceName(String name, Map<String, Object> data_sources) {
        String dataSourceName = name;
        if (name == null) {
            dataSourceName = data_sources.keySet().iterator().next();
        }
        return dataSourceName;
    }

    static {
        DEFAULT_DRIVER_NAMES.put("mysql", "com.mysql.jdbc.Driver");
        DEFAULT_DRIVER_NAMES.put("postgresql", "org.postgresql.Driver");
        DEFAULT_DRIVER_NAMES.put("h2", "org.h2.Driver");
        DEFAULT_DRIVER_NAMES.put("edb", "com.edb.Driver");
        DEFAULT_DRIVER_NAMES.put("ibmdb2", "com.ibm.db2.jcc.DB2Driver");
        DEFAULT_DRIVER_NAMES.put("oracle", "oracle.jdbc.OracleDriver");
        DEFAULT_DRIVER_NAMES.put("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        DEFAULT_DRIVER_NAMES.put("sybase", "net.sourceforge.jtds.jdbc.Driver");
        DEFAULT_DRIVER_NAMES.put("teiid", "org.teiid.jdbc.TeiidDriver");
        DEFAULT_DRIVER_NAMES.put("mariadb", "org.mariadb.jdbc.MariaDbDataSource");
        DEFAULT_DRIVER_NAMES.put("derby", "org.apache.derby.jdbc.EmbeddedDriver");
        DEFAULT_DRIVER_NAMES.put("hive2", "org.apache.hive.jdbc.HiveDriver");
        DEFAULT_DRIVER_NAMES.put("prestodb", "com.simba.presto.jdbc42.Driver");
    }
}

