/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import org.arquillian.ape.core.RunnerExpressionParser;
import org.arquillian.ape.rdbms.core.DatabaseConfiguration;

public class SpringBootLoader {
    private static final String JDBC_URI_PROPERTY_NAME = "spring.datasource.url";
    private static final String USERNAME_PROPERTY_NAME = "spring.datasource.username";
    private static final String PASSWORD_PROPERTY_NAME = "spring.datasource.password";
    private static final String DRIVER_PROPERTY_NAME = "spring.datasource.driverClassName";

    public static DatabaseConfiguration load(String location) {
        InputStream configurationFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (configurationFile == null) {
            throw new IllegalArgumentException(String.format("Spring Boot configuration file %s not found in classpath.", location));
        }
        Properties properties = new Properties();
        try {
            properties.load(configurationFile);
            String jdbc = properties.getProperty(JDBC_URI_PROPERTY_NAME);
            String driverClass = properties.getProperty(DRIVER_PROPERTY_NAME);
            String username = properties.getProperty(USERNAME_PROPERTY_NAME);
            String password = properties.getProperty(PASSWORD_PROPERTY_NAME);
            return new DatabaseConfiguration(URI.create(RunnerExpressionParser.parseExpressions((String)jdbc)), Class.forName(RunnerExpressionParser.parseExpressions((String)driverClass)), RunnerExpressionParser.parseExpressions((String)username), RunnerExpressionParser.parseExpressions((String)password));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

