/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core;

import java.util.Collection;
import java.util.Map;
import org.arquillian.ape.api.AbstractDeclarativeSupport;
import org.arquillian.ape.api.Authentication;
import org.arquillian.ape.api.Driver;
import org.arquillian.ape.api.MetadataExtractor;
import org.arquillian.ape.api.NoType;
import org.arquillian.ape.api.Server;
import org.arquillian.ape.api.Uri;
import org.arquillian.ape.api.UsingDataSet;
import org.arquillian.ape.core.RunnerExpressionParser;
import org.arquillian.ape.rdbms.core.RdbmsPopulator;
import org.arquillian.ape.rdbms.core.RdbmsPopulatorConfigurator;
import org.jboss.arquillian.test.spi.TestClass;

public abstract class RdbmsDeclarativeSupport
extends AbstractDeclarativeSupport {
    private RdbmsPopulator rdbmsPopulator;
    private RdbmsPopulatorConfigurator rdbmsPopulatorConfigurator;

    protected RdbmsDeclarativeSupport(RdbmsPopulator rdbmsPopulator) {
        this.rdbmsPopulator = rdbmsPopulator;
    }

    protected void configureConnection(Collection<Server> serverAnnotations, Collection<Uri> uriAnnotations, Map<String, Object> options, TestClass testClass) {
        if (serverAnnotations.size() == 1) {
            RdbmsPopulatorConfigurator rdbmsPopulatorConfigurator;
            Server serverAnnotation = serverAnnotations.iterator().next();
            int port = Integer.parseInt(RunnerExpressionParser.parseExpressions((String)serverAnnotation.port()));
            this.rdbmsPopulatorConfigurator = rdbmsPopulatorConfigurator = (RdbmsPopulatorConfigurator)this.rdbmsPopulator.forServer(RunnerExpressionParser.parseExpressions((String)serverAnnotation.host()), port);
        } else if (uriAnnotations.size() == 1) {
            RdbmsPopulatorConfigurator rdbmsPopulatorConfigurator;
            Uri uriAnnotation = uriAnnotations.iterator().next();
            this.rdbmsPopulatorConfigurator = rdbmsPopulatorConfigurator = (RdbmsPopulatorConfigurator)this.rdbmsPopulator.forUri(RunnerExpressionParser.parseExpressions((String)uriAnnotation.value()));
        }
        if (this.rdbmsPopulatorConfigurator != null) {
            Collection driverAnnotation;
            this.rdbmsPopulatorConfigurator.withOptions(options);
            MetadataExtractor metadataExtractor = new MetadataExtractor(testClass);
            Collection authenticationAnnotation = metadataExtractor.authentication().getAnnotationsOnClassLevel();
            if (authenticationAnnotation.size() == 1) {
                Authentication auth = (Authentication)authenticationAnnotation.iterator().next();
                this.rdbmsPopulatorConfigurator.withUsername(RunnerExpressionParser.parseExpressions((String)auth.username())).withPassword(RunnerExpressionParser.parseExpressions((String)auth.password()));
            }
            if ((driverAnnotation = metadataExtractor.driver().getAnnotationsOnClassLevel(driver -> driver.type() == this.getPopulatorAnnotation() || driver.type() == NoType.class)).size() == 1) {
                Driver driver2 = (Driver)driverAnnotation.iterator().next();
                this.rdbmsPopulatorConfigurator.withDriver(driver2.value());
            }
        }
    }

    protected void populateData(UsingDataSet usingDataSet) {
        if (this.rdbmsPopulatorConfigurator == null) {
            return;
        }
        String[] value = usingDataSet.value();
        this.rdbmsPopulatorConfigurator.usingDataSets(value);
        this.rdbmsPopulatorConfigurator.execute();
    }

    protected void cleanData() {
        if (this.rdbmsPopulatorConfigurator == null) {
            return;
        }
        this.rdbmsPopulatorConfigurator.clean();
    }
}

