/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core;

import java.io.InputStream;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.arquillian.ape.core.RunnerExpressionParser;
import org.arquillian.ape.rdbms.core.DatabaseConfiguration;

public class JpaPersistenceLoader {
    private static final String JDBC_URI_PROPERTY_NAME = "javax.persistence.jdbc.url";
    private static final String USERNAME_PROPERTY_NAME = "javax.persistence.jdbc.user";
    private static final String PASSWORD_PROPERTY_NAME = "javax.persistence.jdbc.password";
    private static final String DRIVER_PROPERTY_NAME = "javax.persistence.jdbc.driver";

    public static DatabaseConfiguration load(String location) {
        InputStream persistenceContent = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (persistenceContent == null) {
            throw new IllegalArgumentException(String.format("Persistence file %s not found in classpath.", location));
        }
        DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(persistenceContent);
            while (xmlEventReader.hasNext()) {
                Attribute name;
                StartElement startElement;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement() || !"property".equalsIgnoreCase((startElement = xmlEvent.asStartElement()).getName().getLocalPart()) || (name = startElement.getAttributeByName(new QName("name"))) == null) continue;
                switch (name.getValue()) {
                    case "javax.persistence.jdbc.url": {
                        databaseConfiguration.setJdbc(URI.create(JpaPersistenceLoader.extractValue(startElement)));
                        break;
                    }
                    case "javax.persistence.jdbc.user": {
                        databaseConfiguration.setUsername(JpaPersistenceLoader.extractValue(startElement));
                        break;
                    }
                    case "javax.persistence.jdbc.password": {
                        databaseConfiguration.setPassword(JpaPersistenceLoader.extractValue(startElement));
                        break;
                    }
                    case "javax.persistence.jdbc.driver": {
                        databaseConfiguration.setJdbcDriver(Class.forName(JpaPersistenceLoader.extractValue(startElement)));
                    }
                }
            }
        }
        catch (ClassNotFoundException | XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        return databaseConfiguration;
    }

    private static String extractValue(StartElement startElement) {
        return RunnerExpressionParser.parseExpressions((String)startElement.getAttributeByName(new QName("value")).getValue());
    }
}

