/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.rdbms.core.RdbmsPopulatorService;
import org.arquillian.ape.spi.Populator;

public class RdbmsPopulatorConfigurator
implements Populator.PopulatorConfigurator {
    private RdbmsPopulatorService populatorService;
    private URI jdbc;
    private String username;
    private String password;
    private Class<?> driverName;
    private List<String> datasets = new ArrayList<String>();
    private Map<String, Object> options = new HashMap<String, Object>();

    RdbmsPopulatorConfigurator(URI jdbcUrl, RdbmsPopulatorService populatorService) {
        this.jdbc = jdbcUrl;
        this.populatorService = populatorService;
    }

    public RdbmsPopulatorConfigurator withUsername(String username) {
        this.username = username;
        return this;
    }

    public RdbmsPopulatorConfigurator withPassword(String password) {
        this.password = password;
        return this;
    }

    public RdbmsPopulatorConfigurator withDriver(Class<?> driver) {
        this.driverName = driver;
        return this;
    }

    public RdbmsPopulatorConfigurator usingDataSet(String dataset) {
        this.datasets.add(dataset);
        return this;
    }

    public RdbmsPopulatorConfigurator usingDataSets(String ... datasets) {
        this.datasets.addAll(Arrays.asList(datasets));
        return this;
    }

    public RdbmsPopulatorConfigurator withOption(String key, String value, String ... elements) {
        if (elements.length % 2 != 0) {
            throw new IllegalArgumentException("Extra options should be passed in form of (key, value)");
        }
        this.options.put(key, value);
        for (int i = 0; i < elements.length; i += 2) {
            this.options.put(elements[i], elements[i + 1]);
        }
        return this;
    }

    public RdbmsPopulatorConfigurator withOptions(Map<String, Object> options) {
        this.options.putAll(options);
        return this;
    }

    public void execute() {
        try {
            this.populatorService.connect(this.jdbc, this.username, this.password, this.driverName, this.options);
            this.populatorService.execute(Collections.unmodifiableList(this.datasets));
        }
        finally {
            this.populatorService.disconnect();
        }
    }

    public void clean() {
        try {
            this.populatorService.connect(this.jdbc, this.username, this.password, this.driverName, this.options);
            this.populatorService.clean(this.datasets);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.populatorService.disconnect();
        }
    }
}

