/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;

public class DbUnitOptions
implements Map<String, Object> {
    private static final String FEATURE_PREFIX = "http://www.dbunit.org/features/";
    private static final String PROPERTY_PREFIX = "http://www.dbunit.org/properties/";
    static String SCHEMA = "schema";
    static String BATCHED_STATEMENTS = "batchedStatements";
    static String CASE_SENSITIVE_TABLE_NAMES = "caseSensitiveTableNames";
    static String QUALIFIED_TABLE_NAMES = "qualifiedTableNames";
    static String DATATYPE_WARNING = "datatypeWarning";
    static String SKIP_ORACLE_RECYCLE_BIN_TABLES = "skipOracleRecycleBinTables";
    static String ALLOW_EMPTY_FIELDS = "allowEmptyFields";
    static String ESCAPE_PATTERN = "escapePattern";
    static String TABLE_TYPE = "tableType";
    static String DATATYPE_FACTORY = "datatypeFactory";
    static String STATEMENT_FACTORY = "statementFactory";
    static String RESULT_SET_TABLE_FACTORY = "resultSetTableFactory";
    static String PRIMARY_KEY_FILTER = "primaryKeyFilter";
    static String IDENTITY_COLUMN_FILTER = "identityColumnFilter";
    static String BATCH_SIZE = "batchSize";
    static String FETCH_SIZE = "fetchSize";
    static String METADATA_HANDLER = "metadataHandler";
    private Map<String, Object> options = new HashMap<String, Object>();

    private DbUnitOptions() {
    }

    DbUnitOptions(Map<String, Object> options) {
        this.options.putAll(options);
    }

    public static DbUnitConfigurationOptions options() {
        return new DbUnitConfigurationOptions();
    }

    @Override
    public int size() {
        return this.options.size();
    }

    @Override
    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.options.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.options.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.options.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.options.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.options.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.options.putAll(m);
    }

    @Override
    public void clear() {
        this.options.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.options.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.options.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.options.entrySet();
    }

    void configure(DatabaseConfig databaseConfig) {
        databaseConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
        this.configureFeatures(databaseConfig);
        this.configureProperties(databaseConfig);
    }

    private void configureProperties(DatabaseConfig databaseConfig) {
        this.setProperty(ESCAPE_PATTERN, databaseConfig);
        this.setProperty(TABLE_TYPE, databaseConfig);
        this.setProperty(DATATYPE_FACTORY, databaseConfig);
        this.setProperty(STATEMENT_FACTORY, databaseConfig);
        this.setProperty(RESULT_SET_TABLE_FACTORY, databaseConfig);
        this.setProperty(PRIMARY_KEY_FILTER, databaseConfig);
        this.setIdentityColumnFilter(databaseConfig);
        this.setProperty(BATCH_SIZE, databaseConfig);
        this.setProperty(FETCH_SIZE, databaseConfig);
        this.setProperty(METADATA_HANDLER, databaseConfig);
    }

    private void configureFeatures(DatabaseConfig databaseConfig) {
        this.setFeature(BATCHED_STATEMENTS, databaseConfig);
        this.setFeature(CASE_SENSITIVE_TABLE_NAMES, databaseConfig);
        this.setFeature(QUALIFIED_TABLE_NAMES, databaseConfig);
        this.setFeature(DATATYPE_WARNING, databaseConfig);
        this.setFeature(SKIP_ORACLE_RECYCLE_BIN_TABLES, databaseConfig);
        this.setFeature(ALLOW_EMPTY_FIELDS, databaseConfig);
    }

    private void setIdentityColumnFilter(DatabaseConfig databaseConfig) {
        if (this.options.containsKey(IDENTITY_COLUMN_FILTER)) {
            String key = "http://www.dbunit.org/properties/mssql/" + IDENTITY_COLUMN_FILTER;
            databaseConfig.setProperty(key, this.options.get(IDENTITY_COLUMN_FILTER));
        }
    }

    private void setProperty(String property, DatabaseConfig databaseConfig) {
        if (this.options.containsKey(property)) {
            String key = PROPERTY_PREFIX + property;
            databaseConfig.setProperty(key, this.options.get(property));
        }
    }

    private void setFeature(String property, DatabaseConfig databaseConfig) {
        if (this.options.containsKey(property)) {
            String key = FEATURE_PREFIX + property;
            databaseConfig.setProperty(key, this.options.get(property));
        }
    }

    public static class DbUnitConfigurationOptions {
        private DbUnitOptions dbUnitOptions = new DbUnitOptions();

        private DbUnitConfigurationOptions() {
        }

        public DbUnitConfigurationOptions schema(String schema) {
            this.dbUnitOptions.put(SCHEMA, (Object)schema);
            return this;
        }

        public DbUnitConfigurationOptions batchedStatements(boolean batchedStatements) {
            this.dbUnitOptions.put(BATCHED_STATEMENTS, (Object)batchedStatements);
            return this;
        }

        public DbUnitConfigurationOptions caseSensitiveTableNames(boolean caseSensitiveTableNames) {
            this.dbUnitOptions.put(CASE_SENSITIVE_TABLE_NAMES, (Object)caseSensitiveTableNames);
            return this;
        }

        public DbUnitConfigurationOptions qualifiedTableNames(boolean qualifiedTableNames) {
            this.dbUnitOptions.put(QUALIFIED_TABLE_NAMES, (Object)qualifiedTableNames);
            return this;
        }

        public DbUnitConfigurationOptions datatypeWarning(boolean datatypeWarning) {
            this.dbUnitOptions.put(DATATYPE_WARNING, (Object)datatypeWarning);
            return this;
        }

        public DbUnitConfigurationOptions skipOracleRecycleBinTables(boolean skipOracleRecycleBinTables) {
            this.dbUnitOptions.put(SKIP_ORACLE_RECYCLE_BIN_TABLES, (Object)skipOracleRecycleBinTables);
            return this;
        }

        public DbUnitConfigurationOptions allowEmptyFields(boolean allowEmptyFields) {
            this.dbUnitOptions.put(ALLOW_EMPTY_FIELDS, (Object)allowEmptyFields);
            return this;
        }

        public DbUnitConfigurationOptions escapePattern(String escapePattern) {
            this.dbUnitOptions.put(ESCAPE_PATTERN, (Object)escapePattern);
            return this;
        }

        public DbUnitConfigurationOptions tableType(String[] tableType) {
            this.dbUnitOptions.put(TABLE_TYPE, (Object)tableType);
            return this;
        }

        public DbUnitConfigurationOptions datatypeFactory(IDataTypeFactory iDataTypeFactory) {
            this.dbUnitOptions.put(DATATYPE_FACTORY, (Object)iDataTypeFactory);
            return this;
        }

        public DbUnitConfigurationOptions statementFactory(IStatementFactory iStatementFactory) {
            this.dbUnitOptions.put(STATEMENT_FACTORY, (Object)iStatementFactory);
            return this;
        }

        public DbUnitConfigurationOptions resultSetTableFactory(IResultSetTableFactory iResultSetTableFactory) {
            this.dbUnitOptions.put(RESULT_SET_TABLE_FACTORY, (Object)iResultSetTableFactory);
            return this;
        }

        public DbUnitConfigurationOptions primaryKeyFilter(IColumnFilter iColumnFilter) {
            this.dbUnitOptions.put(PRIMARY_KEY_FILTER, (Object)iColumnFilter);
            return this;
        }

        public DbUnitConfigurationOptions identityColumnFilter(IColumnFilter iColumnFilter) {
            this.dbUnitOptions.put(IDENTITY_COLUMN_FILTER, (Object)iColumnFilter);
            return this;
        }

        public DbUnitConfigurationOptions batchSize(int batchSize) {
            this.dbUnitOptions.put(BATCH_SIZE, (Object)batchSize);
            return this;
        }

        public DbUnitConfigurationOptions fetchSize(int fetchSize) {
            this.dbUnitOptions.put(FETCH_SIZE, (Object)fetchSize);
            return this;
        }

        public DbUnitConfigurationOptions metadataHandler(IMetadataHandler metadataHandler) {
            this.dbUnitOptions.put(METADATA_HANDLER, (Object)metadataHandler);
            return this;
        }

        public DbUnitOptions build() {
            return this.dbUnitOptions;
        }
    }
}

