/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.dbunit.dataset.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.rdbms.core.dbunit.dataset.json.DataSetProducer;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.dbunit.dataset.DataSetException;

public class JsonDataSetProducer
extends DataSetProducer {
    public JsonDataSetProducer(InputStream input) {
        super(input);
    }

    @Override
    Map<String, List<Map<String, String>>> loadDataSet() throws DataSetException {
        Map dataset;
        try {
            dataset = (Map)new ObjectMapper().readValue(this.input, Map.class);
        }
        catch (JsonParseException e) {
            throw new DataSetException("Error parsing json data set", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new DataSetException("Error mapping json data set", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataSetException("Error opening json data set", (Throwable)e);
        }
        return dataset;
    }
}

