/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.filter;

import java.util.Collection;
import java.util.logging.Logger;
import org.arquillian.ape.rdbms.core.util.Strings;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.filter.DefaultDatabaseSequenceFilterProvider;
import org.arquillian.ape.rdbms.dbunit.filter.OracleDatabaseSequenceFilterProvider;
import org.arquillian.ape.rdbms.util.JavaSPIExtensionLoader;
import org.arquillian.ape.spi.dbunit.filter.TableFilterProvider;

public class TableFilterResolver {
    private static final Logger log = Logger.getLogger(TableFilterResolver.class.getName());
    private final DBUnitConfiguration dbUnitConfiguration;

    public TableFilterResolver(DBUnitConfiguration dbUnitConfiguration) {
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public TableFilterProvider resolve() {
        if (Strings.isEmpty((String)this.dbUnitConfiguration.getCustomTableFilter())) {
            return new DefaultDatabaseSequenceFilterProvider();
        }
        TableFilterProvider resolved = null;
        Collection databaseSequenceFilterProviders = new JavaSPIExtensionLoader().all(Thread.currentThread().getContextClassLoader(), TableFilterProvider.class);
        for (TableFilterProvider databaseSequenceFilterProvider : databaseSequenceFilterProviders) {
            if (!databaseSequenceFilterProvider.simpleName().equals(this.dbUnitConfiguration.getCustomTableFilter())) continue;
            resolved = databaseSequenceFilterProvider;
        }
        if (resolved == null) {
            log.warning("Unable to find sequence filter for " + this.dbUnitConfiguration.getCustomTableFilter() + ". Using default database sequence filter.");
            log.warning("Available filters: " + this.printFiltersWithNames(databaseSequenceFilterProviders));
            return new OracleDatabaseSequenceFilterProvider();
        }
        return resolved;
    }

    private String printFiltersWithNames(Collection<TableFilterProvider> databaseSequenceFilterProviders) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (TableFilterProvider databaseSequenceFilterProvider : databaseSequenceFilterProviders) {
            sb.append("{name=").append(databaseSequenceFilterProvider.simpleName()).append(", class=").append(databaseSequenceFilterProvider.getClass().getName()).append("},");
        }
        if (!databaseSequenceFilterProviders.isEmpty()) {
            sb.replace(sb.lastIndexOf(","), sb.lastIndexOf(","), "]");
        } else {
            sb.append(']');
        }
        return sb.toString();
    }
}

