/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.arquillian.ape.rdbms.dbunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnsHolder {

    final List<String> global = new ArrayList<String>();

    final Map<String, List<String>> columnsPerTable = new HashMap<String, List<String>>();

    public ColumnsHolder(String[] columns) {
        for (String column : columns) {
            if (column.length() == 0) {
                continue;
            }
            if (!column.contains(".")) {
                global.add(column);
            } else {
                splitTableAndColumn(column);
            }
        }
    }

    private void splitTableAndColumn(String columnToExclude) {
        final String[] splittedTableAndColumn = columnToExclude.split("\\.");

        if (splittedTableAndColumn.length != 2) {
            throw new IllegalArgumentException("Cannot associated table with column for [" + columnToExclude
                + "]. Expected format: 'tableName.columnName'");
        }

        final String tableName = splittedTableAndColumn[0];
        List<String> tableColumns = columnsPerTable.get(tableName);

        if (tableColumns == null) {
            tableColumns = new ArrayList<String>();
            columnsPerTable.put(tableName, tableColumns);
        }

        tableColumns.add(splittedTableAndColumn[1]);
    }
}
