/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.lifecycle;

import java.lang.reflect.Method;
import org.arquillian.ape.rdbms.ShouldMatchDataSet;
import org.arquillian.ape.rdbms.core.event.AfterPersistenceTest;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.metadata.DbUnitMetadataExtractor;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionFeatureResolver;
import org.arquillian.ape.rdbms.dbunit.api.CustomColumnFilter;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.data.provider.DataSetProvider;
import org.arquillian.ape.rdbms.dbunit.data.provider.ExpectedDataSetProvider;
import org.arquillian.ape.rdbms.dbunit.event.CompareDBUnitData;
import org.arquillian.ape.rdbms.dbunit.event.PrepareDBUnitData;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DataSetHandler {
    @Inject
    private Instance<DbUnitMetadataExtractor> metadataExtractorInstance;
    @Inject
    private Instance<DBUnitConfiguration> configurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;
    @Inject
    private Event<PrepareDBUnitData> prepareDataEvent;
    @Inject
    private Event<CompareDBUnitData> compareDataEvent;

    public void prepareDatabase(@Observes(precedence=20) BeforePersistenceTest beforePersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldSeedData()) {
            DataSetProvider dataSetProvider = new DataSetProvider((DbUnitMetadataExtractor)this.metadataExtractorInstance.get(), (DBUnitConfiguration)((Object)this.configurationInstance.get()));
            this.prepareDataEvent.fire((Object)new PrepareDBUnitData(dataSetProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
        }
    }

    public void verifyDatabase(@Observes(precedence=30) AfterPersistenceTest afterPersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldVerifyDataAfterTest()) {
            DbUnitMetadataExtractor metadataExtractor = (DbUnitMetadataExtractor)this.metadataExtractorInstance.get();
            ExpectedDataSetProvider dataSetProvider = new ExpectedDataSetProvider(metadataExtractor, (DBUnitConfiguration)((Object)this.configurationInstance.get()));
            Method testMethod = afterPersistenceTest.getTestMethod();
            ShouldMatchDataSet dataSetsToVerify = (ShouldMatchDataSet)metadataExtractor.shouldMatchDataSet().fetchFrom(testMethod);
            CustomColumnFilter customColumnFilter = (CustomColumnFilter)metadataExtractor.using(CustomColumnFilter.class).fetchFrom(testMethod);
            CompareDBUnitData compareDBUnitDataEvent = new CompareDBUnitData(dataSetProvider.getDescriptorsDefinedFor(testMethod), dataSetsToVerify.orderBy(), dataSetsToVerify.excludeColumns());
            if (customColumnFilter != null) {
                compareDBUnitDataEvent.add(customColumnFilter.value());
            }
            this.compareDataEvent.fire((Object)compareDBUnitDataEvent);
        }
    }
}

