/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.cleanup;

import java.util.logging.Logger;
import org.arquillian.ape.rdbms.core.dbunit.dataset.DataSetRegister;
import org.arquillian.ape.rdbms.dbunit.DataSetUtils;
import org.arquillian.ape.rdbms.dbunit.cleanup.CleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.exception.DBUnitDataSetHandlingException;
import org.arquillian.ape.rdbms.dbunit.filter.TableFilterResolver;
import org.arquillian.ape.spi.dbunit.filter.TableFilterProvider;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;

public class UsedTablesOnlyCleanupStrategyExecutor
implements CleanupStrategyExecutor {
    private static final Logger LOG = Logger.getLogger(UsedTablesOnlyCleanupStrategyExecutor.class.getName());
    private final DatabaseConnection connection;
    private final DataSetRegister dataSetRegister;
    private final DBUnitConfiguration dbUnitConfiguration;

    public UsedTablesOnlyCleanupStrategyExecutor(DatabaseConnection connection, DataSetRegister dataSetRegister, DBUnitConfiguration dbUnitConfiguration) {
        this.connection = connection;
        this.dataSetRegister = dataSetRegister;
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    @Override
    public void cleanupDatabase(String ... tablesToExclude) {
        if (this.dataSetRegister.getInitial() == null || this.dataSetRegister.getInitial().isEmpty()) {
            LOG.warning("Attempted to cleanup database using USED_TABLES_ONLY strategy, but no data sets were used.");
            return;
        }
        try {
            IDataSet mergeDataSets = DataSetUtils.mergeDataSets(this.dataSetRegister.getInitial());
            IDataSet dataSet = DataSetUtils.excludeTables(mergeDataSets, tablesToExclude);
            if (this.dbUnitConfiguration.isFilterTables()) {
                TableFilterProvider tableFilterProvider = new TableFilterResolver(this.dbUnitConfiguration).resolve();
                ITableFilter tableFilter = tableFilterProvider.provide((IDatabaseConnection)this.connection, dataSet.getTableNames());
                dataSet = new FilteredDataSet(tableFilter, dataSet);
            }
            DatabaseOperation.DELETE_ALL.execute((IDatabaseConnection)this.connection, dataSet);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to clean database.", e);
        }
    }
}

