/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.arquillian.ape.rdbms.core.command.DumpDataCommand;
import org.arquillian.ape.rdbms.core.configuration.PersistenceConfiguration;
import org.arquillian.ape.rdbms.core.data.dump.DataDump;
import org.arquillian.ape.rdbms.core.data.dump.DataStateLogger;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.event.CleanupData;
import org.arquillian.ape.rdbms.core.event.PersistenceEvent;
import org.arquillian.ape.rdbms.dbunit.event.PrepareDBUnitData;
import org.arquillian.ape.rdbms.dbunit.exception.DBUnitDataSetHandlingException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.TestClass;

public class DBUnitDataStateLogger
implements DataStateLogger<PrepareDBUnitData> {
    private static final String FILENAME_PATTERN = "[%s]-%s#%s-%s.xml";
    @Inject
    private Instance<DatabaseConnection> databaseConnection;
    @Inject
    private Instance<PersistenceConfiguration> configuration;
    @Inject
    private Instance<CommandService> commandService;
    private TestClass testClass;
    private Method testMethod;

    public void beforePersistenceTest(@Observes EventContext<BeforePersistenceTest> context) {
        this.testClass = ((BeforePersistenceTest)context.getEvent()).getTestClass();
        this.testMethod = ((BeforePersistenceTest)context.getEvent()).getTestMethod();
        context.proceed();
    }

    public void aroundDataSeeding(@Observes EventContext<PrepareDBUnitData> context) {
        if (!((PersistenceConfiguration)this.configuration.get()).isDumpData()) {
            context.proceed();
            return;
        }
        PrepareDBUnitData event = (PrepareDBUnitData)((Object)context.getEvent());
        this.dumpDatabaseState((PersistenceEvent)event, Phase.BEFORE_SEED);
        context.proceed();
        this.dumpDatabaseState((PersistenceEvent)event, Phase.AFTER_SEED);
    }

    public void aroundCleanup(@Observes EventContext<CleanupData> context) {
        if (!((PersistenceConfiguration)this.configuration.get()).isDumpData()) {
            context.proceed();
            return;
        }
        CleanupData event = (CleanupData)context.getEvent();
        this.dumpDatabaseState((PersistenceEvent)event, Phase.BEFORE_CLEAN);
        context.proceed();
        this.dumpDatabaseState((PersistenceEvent)event, Phase.AFTER_CLEAN);
    }

    private String createFileName(String phaseSuffix) {
        return String.format(FILENAME_PATTERN, System.currentTimeMillis(), this.testClass.getName(), this.testMethod.getName(), phaseSuffix);
    }

    private void dumpDatabaseState(PersistenceEvent event, Phase phase) {
        String path = ((PersistenceConfiguration)this.configuration.get()).getDumpDirectory() + "/" + this.createFileName(phase.getName());
        try {
            IDataSet dbContent = ((DatabaseConnection)this.databaseConnection.get()).createDataSet();
            DataDump dumpData = this.createDataDump(path, dbContent);
            ((CommandService)this.commandService.get()).execute((Command)new DumpDataCommand(dumpData));
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to dump database state to folder " + path, e);
        }
    }

    private DataDump createDataDump(String path, IDataSet dbContent) throws IOException, DataSetException {
        StringWriter stringWriter = new StringWriter();
        FlatXmlDataSet.write((IDataSet)dbContent, (Writer)stringWriter);
        DataDump dumpData = new DataDump(stringWriter.toString(), path);
        stringWriter.close();
        return dumpData;
    }

    private static enum Phase {
        BEFORE_SEED("before-seed"),
        AFTER_SEED("after-seed"),
        BEFORE_CLEAN("before-clean"),
        AFTER_CLEAN("after-clean");

        private final String name;

        private Phase(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

