/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.transaction;

import java.lang.reflect.Method;
import org.arquillian.ape.rdbms.core.configuration.PersistenceConfiguration;
import org.arquillian.ape.rdbms.core.metadata.DbUnitMetadataExtractor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;
import org.jboss.arquillian.transaction.spi.provider.TransactionEnabler;

public class PersistenceExtensionConventionTransactionEnabler
implements TransactionEnabler {
    @Inject
    Instance<PersistenceConfiguration> persistenceConfiguration;
    @Inject
    Instance<DbUnitMetadataExtractor> metadataExtractor;

    public boolean isTransactionHandlingDefinedOnClassLevel(TestEvent testEvent) {
        return this.hasTransactionMetadataDefinedOnClassLevel();
    }

    public boolean isTransactionHandlingDefinedOnMethodLevel(TestEvent testEvent) {
        return this.shouldWrapTestMethodInTransaction(testEvent.getTestMethod());
    }

    public TransactionMode getTransactionModeFromClassLevel(TestEvent testEvent) {
        return ((PersistenceConfiguration)this.persistenceConfiguration.get()).getDefaultTransactionMode();
    }

    public TransactionMode getTransactionModeFromMethodLevel(TestEvent testEvent) {
        return ((PersistenceConfiguration)this.persistenceConfiguration.get()).getDefaultTransactionMode();
    }

    private boolean shouldWrapTestMethodInTransaction(Method method) {
        return this.hasDataSetAnnotation(method) || this.hasApplyScriptAnnotation(method) || this.hasJpaCacheEvictionAnnotation(method) || this.hasCleanupAnnotation(method) || this.hasCleanupUsingScriptAnnotation(method);
    }

    private boolean hasTransactionMetadataDefinedOnClassLevel() {
        return this.hasDataSetAnnotationOnClass() || this.hasApplyScriptAnnotationOnClass() || this.hasPersistenceTestAnnotationOnClass() || this.hasJpaCacheEvictionAnnotationOnClass() || this.hasCreateSchemaAnnotationOnClass() || this.hasCleanupAnnotationOnClass() || this.hasCleanupUsingScriptAnnotationOnClass();
    }

    private boolean hasDataSetAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).usingDataSet().isDefinedOnClassLevel() || ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).shouldMatchDataSet().isDefinedOnClassLevel();
    }

    private boolean hasDataSetAnnotation(Method method) {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).usingDataSet().isDefinedOn(method) || ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).shouldMatchDataSet().isDefinedOn(method);
    }

    private boolean hasApplyScriptAnnotation(Method method) {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).applyScriptBefore().isDefinedOn(method) || ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).applyScriptAfter().isDefinedOn(method);
    }

    private boolean hasApplyScriptAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).applyScriptBefore().isDefinedOnClassLevel() || ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).applyScriptAfter().isDefinedOnClassLevel();
    }

    private boolean hasPersistenceTestAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).hasPersistenceTestAnnotation();
    }

    private boolean hasJpaCacheEvictionAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).jpaCacheEviction().isDefinedOnClassLevel();
    }

    private boolean hasJpaCacheEvictionAnnotation(Method method) {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).jpaCacheEviction().isDefinedOn(method);
    }

    private boolean hasCreateSchemaAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).createSchema().isDefinedOnClassLevel();
    }

    private boolean hasCleanupAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).cleanup().isDefinedOnClassLevel();
    }

    private boolean hasCleanupAnnotation(Method method) {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).cleanup().isDefinedOn(method);
    }

    private boolean hasCleanupUsingScriptAnnotationOnClass() {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).cleanupUsingScript().isDefinedOnClassLevel();
    }

    private boolean hasCleanupUsingScriptAnnotation(Method method) {
        return ((DbUnitMetadataExtractor)((Object)this.metadataExtractor.get())).cleanupUsingScript().isDefinedOn(method);
    }
}

