/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.script.splitter.oracle;

import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.arquillian.ape.spi.script.StatementSplitter;

public class OracleStatementSplitter
implements StatementSplitter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String S_N = "(\\s|\\n)+";
    private static final String IDENTIFIER = "(\\S+|\"[^\"]+\")";
    private static final String BLOCK_START = "(^|(\\s|\\n)+)create(\\s|\\n)+(or(\\s|\\n)+replace(\\s|\\n)+)?(function|library|package((\\s|\\n)+body)?|procedure|trigger|type)(\\s|\\n)+(\\S+|\"[^\"]+\")(\\s|\\n)+.*";
    private static final Pattern BLOCK_START_PATTERN = Pattern.compile("(^|(\\s|\\n)+)create(\\s|\\n)+(or(\\s|\\n)+replace(\\s|\\n)+)?(function|library|package((\\s|\\n)+body)?|procedure|trigger|type)(\\s|\\n)+(\\S+|\"[^\"]+\")(\\s|\\n)+.*", 2);

    public void setStatementDelimiter(String statementDelimiter) {
    }

    public void setTrimStatementDelimiter(boolean trimStatementDelimiter) {
    }

    public String supports() {
        return "oracle";
    }

    public List<String> splitStatements(String script) {
        return this.splitStatements(new StringReader(script));
    }

    public List<String> splitStatements(Reader reader) {
        LineNumberReader lineReader = new LineNumberReader(reader);
        StringBuilder sqlBuffer = new StringBuilder();
        ArrayList<String> statements = new ArrayList<String>();
        try {
            String line;
            boolean plSqlMode = false;
            while ((line = lineReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.matches("[/.]")) {
                    statements.add(sqlBuffer.toString());
                    plSqlMode = false;
                    sqlBuffer.setLength(0);
                    continue;
                }
                if (!plSqlMode && (BLOCK_START_PATTERN.matcher(sqlBuffer).find() || "begin".equalsIgnoreCase(line) || "declare".equalsIgnoreCase(line))) {
                    plSqlMode = true;
                    sqlBuffer.append(line);
                    sqlBuffer.append(LINE_SEPARATOR);
                    continue;
                }
                if (!plSqlMode && line.endsWith(";")) {
                    sqlBuffer.append(line.substring(0, line.lastIndexOf(";")));
                    statements.add(sqlBuffer.toString());
                    sqlBuffer.setLength(0);
                    continue;
                }
                sqlBuffer.append(line);
                sqlBuffer.append(LINE_SEPARATOR);
            }
            if (sqlBuffer != null && sqlBuffer.length() > 0) {
                statements.add(sqlBuffer.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error splitting script.  Cause: " + e, e);
        }
        return statements;
    }
}

