/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.script.splitter;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.arquillian.ape.rdbms.script.SpecialCharactersReplacer;
import org.arquillian.ape.spi.script.StatementSplitter;

public class DefaultStatementSplitter
implements StatementSplitter {
    private static final String CHAR_SEQUENCE_PATTERN = "(?m)'([^']*)'|\"([^\"]*)\"";
    private static final String ANSI_SQL_COMMENTS_PATTERN = "--.*|//.*|(?s)/\\*.*?\\*/|(?s)\\{.*?}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private String statementDelimiter;
    private boolean trimStatementDelimiter;

    public DefaultStatementSplitter() {
        this.statementDelimiter = ";";
        this.trimStatementDelimiter = false;
    }

    public DefaultStatementSplitter(String statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public void setStatementDelimiter(String statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public void setTrimStatementDelimiter(boolean trimStatementDelimiter) {
        this.trimStatementDelimiter = trimStatementDelimiter;
    }

    public String supports() {
        return "default";
    }

    public List<String> splitStatements(String script) {
        script = this.removeComments(new SpecialCharactersReplacer().escape(script));
        return this.splitStatements(new StringReader(script));
    }

    public List<String> splitStatements(Reader reader) {
        BufferedReader lineReader = new BufferedReader(reader);
        ArrayList<String> statements = new ArrayList<String>();
        try {
            String line;
            StringBuilder readSqlStatement = new StringBuilder();
            while ((line = lineReader.readLine()) != null) {
                boolean isFullCommand = this.parseLine(line, readSqlStatement);
                if (!isFullCommand) continue;
                if (this.multipleInlineStatements(line)) {
                    statements.addAll(this.splitInlineStatements(line));
                } else {
                    String trimmed = this.trim(readSqlStatement.toString());
                    if (trimmed.length() > 0) {
                        statements.add(trimmed);
                    }
                }
                readSqlStatement.setLength(0);
            }
            if (this.shouldExecuteRemainingStatements(readSqlStatement)) {
                statements.add(this.trim(readSqlStatement.toString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed parsing file.", e);
        }
        return statements;
    }

    private String removeComments(String script) {
        return script.replaceAll(ANSI_SQL_COMMENTS_PATTERN, "");
    }

    private boolean parseLine(String line, StringBuilder sql) {
        String trimmedLine = this.trimLine(line);
        sql.append(trimmedLine).append(LINE_SEPARATOR);
        return this.isFullCommand(trimmedLine);
    }

    private String trimLine(String line) {
        return line.trim() + (this.isNewLineStatementDelimiter() ? LINE_SEPARATOR : "");
    }

    private boolean shouldExecuteRemainingStatements(StringBuilder sql) {
        return sql.toString().trim().length() > 0;
    }

    private boolean isNewLineStatementDelimiter() {
        return "NEW_LINE".equals(this.statementDelimiter);
    }

    private List<String> splitInlineStatements(String line) {
        ArrayList<String> statements = new ArrayList<String>();
        StringTokenizer sqlStatements = new StringTokenizer(line, this.statementDelimiter);
        while (sqlStatements.hasMoreElements()) {
            String token = sqlStatements.nextToken();
            statements.add(this.trim(token));
        }
        return statements;
    }

    private String trim(String line) {
        String trimmed = new SpecialCharactersReplacer().unescape(line.trim());
        if (!this.lineIsStatementDelimiter(line)) {
            trimmed.replace(LINE_SEPARATOR, " ");
            if (this.trimStatementDelimiter && trimmed.endsWith(this.statementDelimiter)) {
                return trimmed.substring(0, trimmed.length() - this.statementDelimiter.length());
            }
        }
        return trimmed;
    }

    private boolean multipleInlineStatements(String line) {
        if (this.isNewLineStatementDelimiter()) {
            return false;
        }
        return new StringTokenizer(this.markCharSequences(line), this.statementDelimiter).countTokens() > 1;
    }

    private String markCharSequences(String line) {
        return line.replaceAll(CHAR_SEQUENCE_PATTERN, "char_seq");
    }

    private boolean isFullCommand(String line) {
        return this.lineEndsWithStatementDelimiter(line) || this.lineIsStatementDelimiter(line);
    }

    private boolean lineIsStatementDelimiter(String line) {
        boolean isStatementDelimiter = line.equals(this.statementDelimiter);
        if (!isStatementDelimiter && this.isNewLineStatementDelimiter()) {
            isStatementDelimiter = line.matches("^\\r?\\n$|^\\r$");
        }
        return isStatementDelimiter;
    }

    private boolean lineEndsWithStatementDelimiter(String line) {
        boolean ends = line.endsWith(this.statementDelimiter);
        if (!ends && this.isNewLineStatementDelimiter()) {
            ends = line.matches("^.+?\\r?\\n$|^.+?\\r$");
        }
        return ends;
    }
}

