/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.arquillian.ape.rdbms.core.exception.ScriptLoadingException;

public final class ScriptLoader {
    public static String loadScript(String location, Charset charset) {
        StringBuilder builder = new StringBuilder();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\r\n");
            }
        }
        catch (Exception e) {
            throw new ScriptLoadingException("Failed loading script " + location, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ScriptLoadingException("Unable to close script.", e);
                }
            }
        }
        return builder.toString();
    }

    public static boolean isSqlScriptFile(String script) {
        if (script == null) {
            return false;
        }
        return script.endsWith(".sql");
    }
}

