/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.lifecycle;

import java.util.Collection;
import org.arquillian.ape.rdbms.core.command.SchemaCreationControlCommand;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.event.ExecuteScripts;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionFeatureResolver;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.rdbms.script.data.descriptor.SqlScriptResourceDescriptor;
import org.arquillian.ape.rdbms.script.data.provider.SqlScriptProvider;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class SchemaCreationScriptsExecutor {
    @Inject
    private Instance<ScriptingConfiguration> configuration;
    @Inject
    private Event<ExecuteScripts> executeScriptsEvent;
    @Inject
    private Instance<CommandService> commandService;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolver;

    public void createSchema(@Observes(precedence=10) EventContext<BeforePersistenceTest> context) {
        Collection<SqlScriptResourceDescriptor> schemaDescriptors;
        BeforePersistenceTest beforePersistenceTest = (BeforePersistenceTest)((Object)context.getEvent());
        if (((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCreateSchema() && !this.schemaCreated(beforePersistenceTest) && !(schemaDescriptors = SqlScriptProvider.createProviderForCreateSchemaScripts(beforePersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get()).getDescriptors(beforePersistenceTest.getTestClass())).isEmpty()) {
            this.executeScriptsEvent.fire((Object)new ExecuteScripts(beforePersistenceTest, schemaDescriptors));
        }
        context.proceed();
    }

    private boolean schemaCreated(TestEvent beforePersistenceTest) {
        return (Boolean)((CommandService)this.commandService.get()).execute((Command)new SchemaCreationControlCommand(beforePersistenceTest.getTestInstance().getClass().getSimpleName()));
    }
}

