/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.lifecycle;

import javax.sql.DataSource;
import org.arquillian.ape.rdbms.core.configuration.PersistenceConfiguration;
import org.arquillian.ape.rdbms.core.datasource.JndiDataSourceProvider;
import org.arquillian.ape.rdbms.core.event.AfterPersistenceTest;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceClass;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.event.InitializeConfiguration;
import org.arquillian.ape.rdbms.core.metadata.DbUnitMetadataExtractor;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionEnabler;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionFeatureResolver;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionScriptingFeatureResolver;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.spi.datasource.DataSourceProvider;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class PersistenceTestTrigger {
    @Inject
    @ClassScoped
    private InstanceProducer<DbUnitMetadataExtractor> metadataExtractorProducer;
    @Inject
    @ClassScoped
    private InstanceProducer<PersistenceExtensionEnabler> persistenceExtensionEnabler;
    @Inject
    @TestScoped
    private InstanceProducer<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverProvider;
    @Inject
    @TestScoped
    private InstanceProducer<PersistenceExtensionScriptingFeatureResolver> persistenceExtensionScriptingFeatureResolverProvider;
    @Inject
    @TestScoped
    private InstanceProducer<DataSource> dataSourceProducer;
    @Inject
    private Instance<PersistenceConfiguration> configurationInstance;
    @Inject
    private Instance<ScriptingConfiguration> scriptingConfigurationInstance;
    @Inject
    private Event<BeforePersistenceTest> beforePersistenceTestEvent;
    @Inject
    private Event<AfterPersistenceTest> afterPersistenceTestEvent;
    @Inject
    private Event<InitializeConfiguration> initializeConfigurationEvent;
    @Inject
    private Event<BeforePersistenceClass> beforePersistenceClassEvent;
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;

    public void beforeClass(@Observes BeforeClass beforeClass) {
        this.metadataExtractorProducer.set((Object)new DbUnitMetadataExtractor(beforeClass.getTestClass()));
        this.persistenceExtensionEnabler.set((Object)new PersistenceExtensionEnabler((DbUnitMetadataExtractor)((Object)this.metadataExtractorProducer.get())));
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.initializeConfigurationEvent.fire((Object)new InitializeConfiguration());
            this.beforePersistenceClassEvent.fire((Object)new BeforePersistenceClass(beforeClass.getTestClass()));
        }
    }

    public void beforeTest(@Observes(precedence=25) Before beforeTestEvent) {
        PersistenceConfiguration persistenceConfiguration = (PersistenceConfiguration)this.configurationInstance.get();
        this.persistenceExtensionFeatureResolverProvider.set((Object)new PersistenceExtensionFeatureResolver(beforeTestEvent.getTestMethod(), (DbUnitMetadataExtractor)((Object)this.metadataExtractorProducer.get()), persistenceConfiguration));
        this.persistenceExtensionScriptingFeatureResolverProvider.set((Object)new PersistenceExtensionScriptingFeatureResolver(beforeTestEvent.getTestMethod(), (DbUnitMetadataExtractor)((Object)this.metadataExtractorProducer.get()), (ScriptingConfiguration)this.scriptingConfigurationInstance.get()));
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.createDataSource();
            this.beforePersistenceTestEvent.fire((Object)new BeforePersistenceTest((TestEvent)beforeTestEvent));
        }
    }

    public void afterTest(@Observes(precedence=-2) After afterTestEvent) {
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.afterPersistenceTestEvent.fire((Object)new AfterPersistenceTest((TestEvent)afterTestEvent));
        }
    }

    private void createDataSource() {
        String dataSourceName = ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverProvider.get()).getDataSourceName();
        this.dataSourceProducer.set((Object)this.loadDataSource(dataSourceName));
    }

    private DataSource loadDataSource(String dataSourceName) {
        DataSourceProvider dataSourceProvider = (DataSourceProvider)((ServiceLoader)this.serviceLoaderInstance.get()).onlyOne(DataSourceProvider.class, JndiDataSourceProvider.class);
        return dataSourceProvider.lookupDataSource(dataSourceName);
    }
}

