/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.arquillian.ape.rdbms.ApplyScriptAfter;
import org.arquillian.ape.rdbms.ApplyScriptBefore;
import org.arquillian.ape.rdbms.CleanupUsingScript;
import org.arquillian.ape.rdbms.CreateSchema;
import org.arquillian.ape.rdbms.core.data.descriptor.ResourceDescriptor;
import org.arquillian.ape.rdbms.core.dbunit.data.descriptor.Format;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionEnabler;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.rdbms.script.data.provider.SqlScriptProvider;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class PersistenceExtensionDataResourcesTestArchiveEnricher
implements ApplicationArchiveProcessor {
    @Inject
    Instance<ScriptingConfiguration> scriptingConfigurationInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        PersistenceExtensionEnabler persistenceExtensionEnabler = new PersistenceExtensionEnabler(testClass);
        if (!persistenceExtensionEnabler.shouldPersistenceExtensionBeActivated()) {
            return;
        }
        Set<ResourceDescriptor<?>> allDataResources = this.fetchAllDataResources(testClass);
        if (!allDataResources.isEmpty()) {
            this.addResources(applicationArchive, allDataResources);
        }
    }

    private Set<ResourceDescriptor<?>> fetchAllDataResources(TestClass testClass) {
        HashSet allDataSets = new HashSet();
        SqlScriptProvider<ApplyScriptBefore> scriptsAppliedBeforeTestProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedBeforeTest(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<ApplyScriptAfter> scriptsAppliedAfterTestProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedAfterTest(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<CleanupUsingScript> cleanupScriptsProvider = SqlScriptProvider.createProviderForCleanupScripts(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<CreateSchema> createSchemaScripts = SqlScriptProvider.createProviderForCreateSchemaScripts(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        allDataSets.addAll(scriptsAppliedBeforeTestProvider.getDescriptors(testClass));
        allDataSets.addAll(scriptsAppliedAfterTestProvider.getDescriptors(testClass));
        allDataSets.addAll(cleanupScriptsProvider.getDescriptors(testClass));
        allDataSets.addAll(createSchemaScripts.getDescriptors(testClass));
        return allDataSets;
    }

    private void addResources(Archive<?> applicationArchive, Set<ResourceDescriptor<?>> allDataResources) {
        List<String> resources = this.extractPaths(allDataResources);
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            ((EnterpriseArchive)applicationArchive).addAsLibrary((Archive)this.createArchiveWithResources(resources));
        } else if (ResourceContainer.class.isInstance(applicationArchive)) {
            this.addResourcesToApplicationArchive((ResourceContainer)applicationArchive, resources);
        } else {
            throw new RuntimeException("Unsupported archive type " + applicationArchive.getClass().getName());
        }
    }

    private void addResourcesToApplicationArchive(ResourceContainer<?> applicationArchive, List<String> resourcePaths) {
        for (String path : resourcePaths) {
            applicationArchive.addAsResource(path);
        }
    }

    private JavaArchive createArchiveWithResources(Collection<String> resourcePaths) {
        JavaArchive dataSetsArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-persistence-scripts.jar");
        for (String path : resourcePaths) {
            dataSetsArchive.addAsResource(path);
        }
        return dataSetsArchive;
    }

    private List<String> extractPaths(Collection<? extends ResourceDescriptor<?>> descriptors) {
        ArrayList<String> paths = new ArrayList<String>(descriptors.size());
        for (ResourceDescriptor<?> descriptor : descriptors) {
            if (!Format.isFileType((Format)descriptor.getFormat())) continue;
            paths.add(descriptor.getLocation());
        }
        return paths;
    }
}

