/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.configuration;

import java.io.Serializable;
import org.arquillian.ape.api.TestExecutionPhase;
import org.arquillian.ape.rdbms.BuiltInCleanupStrategy;
import org.arquillian.ape.rdbms.DataSeedStrategy;
import org.arquillian.ape.rdbms.core.configuration.Configuration;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;

public class PersistenceConfiguration
extends Configuration
implements Serializable {
    private static final long serialVersionUID = -6930645145050348980L;
    private String defaultDataSource;
    private TransactionMode defaultTransactionMode = TransactionMode.COMMIT;
    private DataSeedStrategy defaultDataSeedStrategy = DataSeedStrategy.INSERT;
    private boolean dumpData = false;
    private String dumpDirectory = System.getProperty("java.io.tmpdir");
    private TestExecutionPhase defaultCleanupPhase = TestExecutionPhase.AFTER;
    private BuiltInCleanupStrategy defaultCleanupStrategy = BuiltInCleanupStrategy.STRICT;

    public PersistenceConfiguration() {
        super("persistence", "arquillian.extension.persistence.");
    }

    private boolean isDefined(String toVerify) {
        return toVerify != null && !"".equals(toVerify.trim());
    }

    public String getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public void setDefaultDataSource(String defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public boolean isDefaultDataSourceDefined() {
        return this.isDefined(this.defaultDataSource);
    }

    public TransactionMode getDefaultTransactionMode() {
        return this.defaultTransactionMode;
    }

    public void setDefaultTransactionMode(TransactionMode defaultTransactionMode) {
        this.defaultTransactionMode = defaultTransactionMode;
    }

    public boolean isDumpData() {
        return this.dumpData;
    }

    public void setDumpData(boolean dumpData) {
        this.dumpData = dumpData;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setDumpDirectory(String dumpDirectory) {
        if (dumpDirectory.endsWith("/")) {
            dumpDirectory = dumpDirectory.substring(0, dumpDirectory.length() - 2);
        }
        this.dumpDirectory = dumpDirectory;
    }

    public TestExecutionPhase getDefaultCleanupPhase() {
        return this.defaultCleanupPhase;
    }

    public void setDefaultCleanupPhase(TestExecutionPhase defaultCleanupPhase) {
        this.defaultCleanupPhase = defaultCleanupPhase;
    }

    public BuiltInCleanupStrategy getDefaultCleanupStrategy() {
        return this.defaultCleanupStrategy;
    }

    public void setDefaultCleanupStrategy(BuiltInCleanupStrategy defaultCleanupStrategy) {
        this.defaultCleanupStrategy = defaultCleanupStrategy;
    }

    public DataSeedStrategy getDefaultDataSeedStrategy() {
        return this.defaultDataSeedStrategy;
    }

    public void setDefaultDataSeedStrategy(DataSeedStrategy defaultDataSeedStrategy) {
        this.defaultDataSeedStrategy = defaultDataSeedStrategy;
    }

    public void setDataSeedStrategy(DataSeedStrategy strategy) {
        this.setDefaultDataSeedStrategy(strategy);
    }
}

