/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.configuration;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.arquillian.ape.rdbms.core.configuration.Configuration;
import org.arquillian.ape.rdbms.core.configuration.ConfigurationTypeConverter;
import org.arquillian.ape.rdbms.core.configuration.ReflectionHelper;
import org.arquillian.ape.rdbms.core.exception.PersistenceExtensionInitializationException;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public class ConfigurationImporter<T extends Configuration> {
    private static final Logger log = Logger.getLogger(ConfigurationImporter.class.getName());
    private final T configuration;

    public ConfigurationImporter(T configuration) {
        this.configuration = configuration;
    }

    public void loadFromArquillianXml(String arquillianXmlFilename) {
        InputStream arqXmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(arquillianXmlFilename);
        ArquillianDescriptor arquillianDescriptor = (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).fromStream(arqXmlStream);
        this.from(arquillianDescriptor);
    }

    public void from(ArquillianDescriptor descriptor) {
        Map<String, String> extensionProperties = this.extractPropertiesFromDescriptor(((Configuration)this.configuration).getQualifier(), descriptor);
        this.createConfiguration(extensionProperties);
    }

    public void loadFromPropertyFile(String propertyFilename) {
        Properties properties = new Properties();
        InputStream propertiesStream = null;
        try {
            propertiesStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFilename);
            properties.load(propertiesStream);
            this.from(properties);
        }
        catch (Exception e) {
            throw new PersistenceExtensionInitializationException("Unable to load Arquillian properties in container. Missing file " + propertyFilename, e);
        }
        finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException e) {
                    throw new PersistenceExtensionInitializationException("Failed to close the stream for file " + propertyFilename, e);
                }
            }
        }
    }

    public void from(Properties properties) {
        Map<String, String> fieldsWithValues = this.convertKeys(properties);
        this.createConfiguration(fieldsWithValues);
    }

    private Map<String, String> convertKeys(Properties properties) {
        HashMap<String, String> convertedFieldsWithValues = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = String.valueOf(property.getKey());
            String value = String.valueOf(property.getValue());
            convertedFieldsWithValues.put(this.convertFromPropertyKey(key), value);
        }
        return convertedFieldsWithValues;
    }

    private String convertFromPropertyKey(String key) {
        key = key.replaceAll(((Configuration)this.configuration).getPrefix(), "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '.') {
                c = Character.toUpperCase(key.charAt(++i));
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void createConfiguration(Map<String, String> fieldsWithValues) {
        ConfigurationTypeConverter typeConverter = new ConfigurationTypeConverter();
        List<Field> fields = ReflectionHelper.getAccessibleFields(this.configuration.getClass());
        for (Field field : fields) {
            String fieldName = field.getName();
            if (!fieldsWithValues.containsKey(fieldName)) continue;
            String value = fieldsWithValues.get(fieldName);
            fieldsWithValues.remove(fieldName);
            Class<?> fieldType = field.getType();
            try {
                Class<?> boxedFieldType = typeConverter.box(fieldType);
                Object convertedValue = typeConverter.convert(value, boxedFieldType);
                if (convertedValue == null || !boxedFieldType.isAssignableFrom(convertedValue.getClass())) continue;
                Method setter = new PropertyDescriptor(fieldName, this.configuration.getClass()).getWriteMethod();
                setter.invoke(this.configuration, convertedValue);
            }
            catch (Exception e) {
                throw new PersistenceExtensionInitializationException("Unable to create persistence configuration.", e);
            }
        }
        if (!fieldsWithValues.keySet().isEmpty()) {
            this.reportNonExistingFields(fieldsWithValues, fields);
        }
    }

    private void reportNonExistingFields(Map<String, String> fieldsWithValues, Collection<Field> fields) {
        Object[] knownFields = this.extractFieldNames(fields);
        log.warning(this.configuration + " does not support properties provided '" + Arrays.toString(fieldsWithValues.keySet().toArray()) + ". Possible values: " + Arrays.toString(knownFields) + "'. Please revise your arquillian.xml. For more details you can refer to the official documentation https://docs.jboss.org/author/display/ARQ/Persistence");
    }

    private Map<String, String> extractPropertiesFromDescriptor(String extensionName, ArquillianDescriptor descriptor) {
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extensionName.equals(extension.getExtensionName())) continue;
            return extension.getExtensionProperties();
        }
        return Collections.emptyMap();
    }

    private String[] extractFieldNames(Collection<Field> fields) {
        String[] knownFields = new String[fields.size()];
        int index = 0;
        for (Field field : fields) {
            knownFields[index++] = field.getName();
        }
        return knownFields;
    }
}

