/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.transaction;

import java.lang.reflect.Method;
import org.arquillian.ape.rdbms.core.configuration.PersistenceConfiguration;
import org.arquillian.ape.rdbms.core.metadata.MetadataExtractor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;
import org.jboss.arquillian.transaction.spi.provider.TransactionEnabler;

public class PersistenceExtensionConventionTransactionEnabler
implements TransactionEnabler {
    @Inject
    Instance<PersistenceConfiguration> persistenceConfiguration;
    @Inject
    Instance<MetadataExtractor> metadataExtractor;

    public boolean isTransactionHandlingDefinedOnClassLevel(TestEvent testEvent) {
        return this.hasTransactionMetadataDefinedOnClassLevel();
    }

    public boolean isTransactionHandlingDefinedOnMethodLevel(TestEvent testEvent) {
        return this.shouldWrapTestMethodInTransaction(testEvent.getTestMethod());
    }

    public TransactionMode getTransactionModeFromClassLevel(TestEvent testEvent) {
        return ((PersistenceConfiguration)this.persistenceConfiguration.get()).getDefaultTransactionMode();
    }

    public TransactionMode getTransactionModeFromMethodLevel(TestEvent testEvent) {
        return ((PersistenceConfiguration)this.persistenceConfiguration.get()).getDefaultTransactionMode();
    }

    private boolean shouldWrapTestMethodInTransaction(Method method) {
        return this.hasDataSetAnnotation(method) || this.hasApplyScriptAnnotation(method) || this.hasJpaCacheEvictionAnnotation(method) || this.hasCleanupAnnotation(method) || this.hasCleanupUsingScriptAnnotation(method);
    }

    private boolean hasTransactionMetadataDefinedOnClassLevel() {
        return this.hasDataSetAnnotationOnClass() || this.hasApplyScriptAnnotationOnClass() || this.hasPersistenceTestAnnotationOnClass() || this.hasJpaCacheEvictionAnnotationOnClass() || this.hasCreateSchemaAnnotationOnClass() || this.hasCleanupAnnotationOnClass() || this.hasCleanupUsingScriptAnnotationOnClass();
    }

    private boolean hasDataSetAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).usingDataSet().isDefinedOnClassLevel() || ((MetadataExtractor)this.metadataExtractor.get()).shouldMatchDataSet().isDefinedOnClassLevel();
    }

    private boolean hasDataSetAnnotation(Method method) {
        return ((MetadataExtractor)this.metadataExtractor.get()).usingDataSet().isDefinedOn(method) || ((MetadataExtractor)this.metadataExtractor.get()).shouldMatchDataSet().isDefinedOn(method);
    }

    private boolean hasApplyScriptAnnotation(Method method) {
        return ((MetadataExtractor)this.metadataExtractor.get()).applyScriptBefore().isDefinedOn(method) || ((MetadataExtractor)this.metadataExtractor.get()).applyScriptAfter().isDefinedOn(method);
    }

    private boolean hasApplyScriptAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).applyScriptBefore().isDefinedOnClassLevel() || ((MetadataExtractor)this.metadataExtractor.get()).applyScriptAfter().isDefinedOnClassLevel();
    }

    private boolean hasPersistenceTestAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).hasPersistenceTestAnnotation();
    }

    private boolean hasJpaCacheEvictionAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).jpaCacheEviction().isDefinedOnClassLevel();
    }

    private boolean hasJpaCacheEvictionAnnotation(Method method) {
        return ((MetadataExtractor)this.metadataExtractor.get()).jpaCacheEviction().isDefinedOn(method);
    }

    private boolean hasCreateSchemaAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).createSchema().isDefinedOnClassLevel();
    }

    private boolean hasCleanupAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).cleanup().isDefinedOnClassLevel();
    }

    private boolean hasCleanupAnnotation(Method method) {
        return ((MetadataExtractor)this.metadataExtractor.get()).cleanup().isDefinedOn(method);
    }

    private boolean hasCleanupUsingScriptAnnotationOnClass() {
        return ((MetadataExtractor)this.metadataExtractor.get()).cleanupUsingScript().isDefinedOnClassLevel();
    }

    private boolean hasCleanupUsingScriptAnnotation(Method method) {
        return ((MetadataExtractor)this.metadataExtractor.get()).cleanupUsingScript().isDefinedOn(method);
    }
}

