/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.script.splitter;

import java.util.Collection;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.rdbms.util.JavaSPIExtensionLoader;
import org.arquillian.ape.spi.script.StatementSplitter;

public class StatementSplitterResolver {
    private final ScriptingConfiguration scriptingConfiguration;

    public StatementSplitterResolver(ScriptingConfiguration scriptingConfiguration) {
        this.scriptingConfiguration = scriptingConfiguration;
    }

    public StatementSplitter resolve() {
        String sqlDialect = this.scriptingConfiguration.getSqlDialect();
        StatementSplitter resolved = null;
        Collection<StatementSplitter> statementSplitters = new JavaSPIExtensionLoader().all(Thread.currentThread().getContextClassLoader(), StatementSplitter.class);
        for (StatementSplitter statementSplitter : statementSplitters) {
            if (!statementSplitter.supports().equalsIgnoreCase(sqlDialect)) continue;
            if (resolved != null) {
                throw new IllegalStateException("Found multiple implementations of " + StatementSplitter.class.getName() + " for specified dialect " + sqlDialect);
            }
            resolved = statementSplitter;
            resolved.setStatementDelimiter(this.scriptingConfiguration.getSqlStatementDelimiter());
        }
        if (resolved == null) {
            throw new IllegalStateException("Unresolvable implementation of " + StatementSplitter.class.getName() + " for specified dialect " + sqlDialect);
        }
        return resolved;
    }
}

