/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.script;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Logger;
import org.arquillian.ape.rdbms.core.exception.ScriptExecutionException;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.spi.script.StatementSplitter;

public class ScriptExecutor {
    private static final Logger log = Logger.getLogger(ScriptExecutor.class.getName());
    private final Connection connection;
    private final ScriptingConfiguration scriptingConfiguration;
    private final StatementSplitter statementSplitter;

    public ScriptExecutor(Connection connection, ScriptingConfiguration scriptingConfiguration, StatementSplitter statementSplitter) {
        this.connection = connection;
        this.scriptingConfiguration = scriptingConfiguration;
        this.statementSplitter = statementSplitter;
    }

    public void execute(String script) {
        List statements = this.statementSplitter.splitStatements(script);
        for (String statement : statements) {
            this.executeStatement(statement);
        }
    }

    void executeStatement(String sqlStatement) {
        if (this.scriptingConfiguration.isShowSql()) {
            log.info("Executing SQL statement: " + sqlStatement);
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(sqlStatement);
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Unable to execute statement: " + sqlStatement, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new ScriptExecutionException("Unable to close statement after script execution.", e);
                }
            }
        }
    }
}

