/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.jpa.cache;

import java.util.Collection;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import org.arquillian.ape.rdbms.JpaCacheEviction;
import org.arquillian.ape.rdbms.JpaCacheEvictionStrategy;
import org.arquillian.ape.rdbms.TestExecutionPhase;
import org.arquillian.ape.rdbms.core.configuration.Configuration;
import org.arquillian.ape.rdbms.core.event.AfterPersistenceTest;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.event.InitializeConfiguration;
import org.arquillian.ape.rdbms.jpa.cache.JpaCacheEvictionConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class JpaCacheEvictionHandler {
    private static final String DEFAULT_JNDI_PREFIX = "java:comp/env/";
    @Inject
    private Instance<Context> ctx;
    private JpaCacheEvictionConfiguration jpaCacheEvictionConfiguration;

    public JpaCacheEvictionHandler() {
    }

    public JpaCacheEvictionHandler(Instance<Context> ctx, JpaCacheEvictionConfiguration jpaCacheEvictionConfiguration) {
        this.ctx = ctx;
        this.jpaCacheEvictionConfiguration = jpaCacheEvictionConfiguration;
    }

    public final void initalizeCacheConfiguration(@Observes InitializeConfiguration event) {
        this.jpaCacheEvictionConfiguration = new JpaCacheEvictionConfiguration();
        Configuration.importTo(this.jpaCacheEvictionConfiguration).loadFromPropertyFile(this.jpaCacheEvictionConfiguration.getPrefix() + "properties");
    }

    public final void onBeforeTestMethod(@Observes(precedence=15) BeforePersistenceTest event) {
        this.executeCacheEviction(event, TestExecutionPhase.BEFORE);
    }

    public final void onAfterTestMethod(@Observes(precedence=45) AfterPersistenceTest event) {
        this.executeCacheEviction(event, TestExecutionPhase.AFTER);
    }

    private void executeCacheEviction(TestEvent event, TestExecutionPhase currentPhase) {
        TestExecutionPhase phase;
        JpaCacheEviction jpaCacheEviction = this.obtainAnnotation(event);
        if (jpaCacheEviction != null && (phase = this.obtainPhase(jpaCacheEviction)).equals((Object)currentPhase)) {
            Collection<EntityManager> ems = this.obtainEntityManagers(jpaCacheEviction);
            JpaCacheEvictionStrategy strategy = this.obtainStrategy(jpaCacheEviction);
            for (EntityManager em : ems) {
                strategy.evictCache(em);
            }
        }
    }

    private Collection<EntityManager> obtainEntityManagers(JpaCacheEviction jpaCacheEviction) {
        String[] emJndiNames;
        LinkedList<EntityManager> entityManagers = new LinkedList<EntityManager>();
        for (String emJndiName : emJndiNames = jpaCacheEviction.entityManager()) {
            entityManagers.add(this.obtainEntityManager(emJndiName));
        }
        return entityManagers;
    }

    private JpaCacheEviction obtainAnnotation(TestEvent event) {
        JpaCacheEviction classLevel = (JpaCacheEviction)event.getTestClass().getAnnotation(JpaCacheEviction.class);
        JpaCacheEviction methodLevel = event.getTestMethod().getAnnotation(JpaCacheEviction.class);
        if (methodLevel != null) {
            return methodLevel;
        }
        return classLevel;
    }

    private TestExecutionPhase obtainPhase(JpaCacheEviction jpaCacheEviction) {
        TestExecutionPhase phase = jpaCacheEviction.phase();
        if (TestExecutionPhase.DEFAULT.equals((Object)phase)) {
            phase = this.jpaCacheEvictionConfiguration.getDefaultPhase();
        }
        return phase;
    }

    private JpaCacheEvictionStrategy obtainStrategy(JpaCacheEviction jpaCacheEviction) {
        Class<? extends JpaCacheEvictionStrategy> strategyClass = jpaCacheEviction.strategy();
        if (JpaCacheEviction.DefaultJpaCacheEvictionStrategy.class.equals((Object)strategyClass)) {
            strategyClass = this.jpaCacheEvictionConfiguration.getDefaultStrategy();
        }
        try {
            return (JpaCacheEvictionStrategy)strategyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain JpaCacheEvictionStrategy.", e);
        }
    }

    private EntityManager obtainEntityManager(String emJndiName) {
        if (emJndiName.length() == 0) {
            emJndiName = this.jpaCacheEvictionConfiguration.getDefaultEntityManager();
        }
        try {
            return this.lookup(emJndiName);
        }
        catch (NamingException e) {
            try {
                return this.lookup(DEFAULT_JNDI_PREFIX + emJndiName);
            }
            catch (NamingException ne) {
                throw new RuntimeException("Failed to obtain EntityManager using JNDI name " + emJndiName + ", but also appending it with default prefix " + DEFAULT_JNDI_PREFIX, e);
            }
        }
    }

    public EntityManager lookup(String emJndiName) throws NamingException {
        return (EntityManager)((Context)this.ctx.get()).lookup(emJndiName);
    }
}

