/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AssertionErrorCollector {
    private final List<Throwable> assertionErrors = new ArrayList<Throwable>();

    public void collect(Throwable error) {
        this.assertionErrors.add(error);
    }

    public void report() {
        if (this.assertionErrors.isEmpty()) {
            return;
        }
        throw new AssertionError((Object)this.createErrorMessage());
    }

    public String showAllErrors() {
        return Arrays.toString(this.assertionErrors.toArray());
    }

    public boolean contains(Class<? extends Throwable> throwable) {
        for (Throwable error : this.assertionErrors) {
            if (!error.getClass().equals(throwable)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.assertionErrors.clear();
    }

    public int amountOfErrors() {
        return this.assertionErrors.size();
    }

    private String createErrorMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("Test failed in ").append(this.amountOfErrors()).append(" case").append(this.amountOfErrors() > 1 ? "s" : "").append(". \n");
        for (Throwable error : this.assertionErrors) {
            builder.append(error.getMessage()).append('\n');
        }
        return builder.toString();
    }
}

