/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.metadata;

import java.lang.reflect.Method;
import org.arquillian.ape.rdbms.Cleanup;
import org.arquillian.ape.rdbms.CleanupStrategy;
import org.arquillian.ape.rdbms.CleanupUsingScript;
import org.arquillian.ape.rdbms.DataSeedStrategy;
import org.arquillian.ape.rdbms.DataSource;
import org.arquillian.ape.rdbms.SeedDataUsing;
import org.arquillian.ape.rdbms.TestExecutionPhase;
import org.arquillian.ape.rdbms.core.configuration.PersistenceConfiguration;
import org.arquillian.ape.rdbms.core.exception.DataSourceNotDefinedException;
import org.arquillian.ape.rdbms.core.metadata.MetadataExtractor;
import org.arquillian.ape.rdbms.core.util.Strings;

public class PersistenceExtensionFeatureResolver {
    private final PersistenceConfiguration configuration;
    private final MetadataExtractor metadataExtractor;
    private final Method testMethod;

    public PersistenceExtensionFeatureResolver(Method testMethod, MetadataExtractor metadataExtractor, PersistenceConfiguration configuration) {
        this.metadataExtractor = metadataExtractor;
        this.configuration = configuration;
        this.testMethod = testMethod;
    }

    public boolean shouldCreateSchema() {
        return this.metadataExtractor.createSchema().isDefinedOnClassLevel();
    }

    public boolean shouldSeedData() {
        return this.metadataExtractor.usingDataSet().isDefinedOnClassLevel() || this.metadataExtractor.usingDataSet().isDefinedOn(this.testMethod);
    }

    public boolean shouldCustomScriptBeAppliedBeforeTestRequested() {
        return this.metadataExtractor.applyScriptBefore().isDefinedOnClassLevel() || this.metadataExtractor.applyScriptBefore().isDefinedOn(this.testMethod);
    }

    public boolean shouldCustomScriptBeAppliedAfterTestRequested() {
        return this.metadataExtractor.applyScriptAfter().isDefinedOnClassLevel() || this.metadataExtractor.applyScriptAfter().isDefinedOn(this.testMethod);
    }

    public boolean shouldVerifyDataAfterTest() {
        return this.metadataExtractor.shouldMatchDataSet().isDefinedOnClassLevel() || this.metadataExtractor.shouldMatchDataSet().isDefinedOn(this.testMethod);
    }

    public TestExecutionPhase getCleanupTestPhase() {
        Cleanup cleanupAnnotation = this.metadataExtractor.cleanup().fetchUsingFirst(this.testMethod);
        TestExecutionPhase phase = this.configuration.getDefaultCleanupPhase();
        if (cleanupAnnotation != null && !TestExecutionPhase.DEFAULT.equals((Object)cleanupAnnotation.phase())) {
            phase = cleanupAnnotation.phase();
        }
        return phase;
    }

    public CleanupStrategy getCleanupStrategy() {
        Cleanup cleanup = this.metadataExtractor.cleanup().fetchUsingFirst(this.testMethod);
        if (cleanup == null || CleanupStrategy.DEFAULT.equals((Object)cleanup.strategy())) {
            return this.configuration.getDefaultCleanupStrategy();
        }
        return cleanup.strategy();
    }

    public DataSeedStrategy getDataSeedStrategy() {
        SeedDataUsing dataSeedingStrategy = this.metadataExtractor.dataSeedStrategy().fetchUsingFirst(this.testMethod);
        if (dataSeedingStrategy == null || DataSeedStrategy.DEFAULT.equals((Object)dataSeedingStrategy.value())) {
            return this.configuration.getDefaultDataSeedStrategy();
        }
        return dataSeedingStrategy.value();
    }

    public boolean shouldCleanup() {
        CleanupUsingScript cleanupUsingScriptAnnotation = this.metadataExtractor.cleanupUsingScript().fetchUsingFirst(this.testMethod);
        return cleanupUsingScriptAnnotation == null || TestExecutionPhase.NONE.equals((Object)cleanupUsingScriptAnnotation.phase());
    }

    public boolean shouldCleanupBefore() {
        return this.shouldCleanup() && TestExecutionPhase.BEFORE.equals((Object)this.getCleanupTestPhase());
    }

    public boolean shouldCleanupAfter() {
        return this.shouldCleanup() && TestExecutionPhase.AFTER.equals((Object)this.getCleanupTestPhase());
    }

    public String getDataSourceName() {
        DataSource dataSourceAnnotation;
        String dataSource = "";
        if (this.configuration.isDefaultDataSourceDefined()) {
            dataSource = this.configuration.getDefaultDataSource();
        }
        if ((dataSourceAnnotation = this.metadataExtractor.dataSource().fetchUsingFirst(this.testMethod)) != null) {
            dataSource = dataSourceAnnotation.value();
        }
        if (Strings.isEmpty(dataSource)) {
            throw new DataSourceNotDefinedException("DataSource not defined! Please declare it in arquillian.xml or by using @DataSource annotation.");
        }
        return dataSource;
    }
}

