/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.metadata;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.ape.rdbms.ApplyScriptAfter;
import org.arquillian.ape.rdbms.ApplyScriptBefore;
import org.arquillian.ape.rdbms.Cleanup;
import org.arquillian.ape.rdbms.CleanupUsingScript;
import org.arquillian.ape.rdbms.CreateSchema;
import org.arquillian.ape.rdbms.DataSource;
import org.arquillian.ape.rdbms.JpaCacheEviction;
import org.arquillian.ape.rdbms.PersistenceTest;
import org.arquillian.ape.rdbms.SeedDataUsing;
import org.arquillian.ape.rdbms.ShouldMatchDataSet;
import org.arquillian.ape.rdbms.UsingDataSet;
import org.arquillian.ape.rdbms.core.metadata.AnnotationInspector;
import org.jboss.arquillian.test.spi.TestClass;

public class MetadataExtractor {
    private final TestClass testClass;
    private final Map<Class<?>, AnnotationInspector<?>> inspectors = new HashMap();

    public MetadataExtractor(TestClass testClass) {
        this.testClass = testClass;
    }

    public <K extends Annotation> void register(TestClass testClass, Class<K> annotation) {
        this.inspectors.put(annotation, new AnnotationInspector<K>(testClass, annotation));
    }

    public <K extends Annotation> AnnotationInspector<K> using(Class<K> annotation) {
        if (this.inspectors.get(annotation) == null) {
            this.register(this.testClass, annotation);
        }
        return this.inspectors.get(annotation);
    }

    public AnnotationInspector<DataSource> dataSource() {
        return this.using(DataSource.class);
    }

    public AnnotationInspector<SeedDataUsing> dataSeedStrategy() {
        return this.using(SeedDataUsing.class);
    }

    public AnnotationInspector<UsingDataSet> usingDataSet() {
        return this.using(UsingDataSet.class);
    }

    public AnnotationInspector<ShouldMatchDataSet> shouldMatchDataSet() {
        return this.using(ShouldMatchDataSet.class);
    }

    public AnnotationInspector<ApplyScriptBefore> applyScriptBefore() {
        return this.using(ApplyScriptBefore.class);
    }

    public AnnotationInspector<ApplyScriptAfter> applyScriptAfter() {
        return this.using(ApplyScriptAfter.class);
    }

    public AnnotationInspector<Cleanup> cleanup() {
        return this.using(Cleanup.class);
    }

    public AnnotationInspector<CleanupUsingScript> cleanupUsingScript() {
        return this.using(CleanupUsingScript.class);
    }

    public AnnotationInspector<JpaCacheEviction> jpaCacheEviction() {
        return this.using(JpaCacheEviction.class);
    }

    public AnnotationInspector<CreateSchema> createSchema() {
        return this.using(CreateSchema.class);
    }

    public boolean hasPersistenceTestAnnotation() {
        return this.testClass.getAnnotation(PersistenceTest.class) != null;
    }

    public Class<?> getJavaClass() {
        return this.testClass.getJavaClass();
    }
}

