/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.arquillian.test.spi.TestClass;

public class AnnotationInspector<T extends Annotation> {
    private final Map<Method, T> annotatedMethods;
    private final TestClass testClass;
    private final Class<T> annotationClass;

    public AnnotationInspector(TestClass testClass, Class<T> annotationClass) {
        this.testClass = testClass;
        this.annotationClass = annotationClass;
        this.annotatedMethods = this.fetch(annotationClass);
    }

    public Collection<T> fetchAll() {
        HashSet<T> all = new HashSet<T>();
        all.addAll(this.annotatedMethods.values());
        T annotationOnClassLevel = this.getAnnotationOnClassLevel();
        if (annotationOnClassLevel != null) {
            all.add(annotationOnClassLevel);
        }
        return all;
    }

    public boolean isDefinedOn(Method method) {
        return this.fetchFrom(method) != null;
    }

    public boolean isDefinedOnAnyMethod() {
        return !this.annotatedMethods.isEmpty();
    }

    public T fetchFrom(Method method) {
        return (T)((Annotation)this.annotatedMethods.get(method));
    }

    public boolean isDefinedOnClassLevel() {
        return this.getAnnotationOnClassLevel() != null;
    }

    public T getAnnotationOnClassLevel() {
        return (T)this.testClass.getAnnotation(this.annotationClass);
    }

    public T fetchUsingFirst(Method testMethod) {
        T usedAnnotation = this.getAnnotationOnClassLevel();
        if (this.isDefinedOn(testMethod)) {
            usedAnnotation = this.fetchFrom(testMethod);
        }
        return usedAnnotation;
    }

    private Map<Method, T> fetch(Class<T> annotation) {
        HashMap<Method, T> map = new HashMap<Method, T>();
        for (Method testMethod : this.testClass.getMethods(annotation)) {
            map.put(testMethod, testMethod.getAnnotation(annotation));
        }
        return map;
    }
}

