/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.lifecycle;

import org.arquillian.ape.rdbms.ApplyScriptAfter;
import org.arquillian.ape.rdbms.ApplyScriptBefore;
import org.arquillian.ape.rdbms.core.event.AfterPersistenceTest;
import org.arquillian.ape.rdbms.core.event.BeforePersistenceTest;
import org.arquillian.ape.rdbms.core.event.ExecuteScripts;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionFeatureResolver;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.rdbms.script.data.provider.SqlScriptProvider;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DataScriptsHandler {
    @Inject
    private Instance<ScriptingConfiguration> configuration;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolver;
    @Inject
    private Event<ExecuteScripts> executeScriptsEvent;

    public void executeBeforeTest(@Observes(precedence=30) BeforePersistenceTest beforePersistenceTest) {
        this.executeCustomScriptsBefore(beforePersistenceTest);
    }

    public void executeAfterTest(@Observes(precedence=40) AfterPersistenceTest afterPersistenceTest) {
        this.executeCustomScriptsAfter(afterPersistenceTest);
    }

    private void executeCustomScriptsBefore(BeforePersistenceTest beforePersistenceTest) {
        if (!((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCustomScriptBeAppliedBeforeTestRequested()) {
            return;
        }
        SqlScriptProvider<ApplyScriptBefore> scriptsProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedBeforeTest(beforePersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get());
        this.executeScriptsEvent.fire((Object)new ExecuteScripts(beforePersistenceTest, scriptsProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
    }

    private void executeCustomScriptsAfter(AfterPersistenceTest afterPersistenceTest) {
        if (!((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCustomScriptBeAppliedAfterTestRequested()) {
            return;
        }
        SqlScriptProvider<ApplyScriptAfter> scriptsProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedAfterTest(afterPersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get());
        this.executeScriptsEvent.fire((Object)new ExecuteScripts(afterPersistenceTest, scriptsProvider.getDescriptorsDefinedFor(afterPersistenceTest.getTestMethod())));
    }
}

