/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.datasource;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.arquillian.ape.rdbms.core.exception.ContextNotAvailableException;
import org.arquillian.ape.rdbms.core.exception.DataSourceNotFoundException;
import org.arquillian.ape.spi.datasource.DataSourceProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class JndiDataSourceProvider
implements DataSourceProvider {
    @Inject
    private Instance<Context> contextInstance;

    public DataSource lookupDataSource(String dataSourceName) {
        try {
            Context context = (Context)this.contextInstance.get();
            if (context == null) {
                throw new ContextNotAvailableException("No Naming Context available.");
            }
            return (DataSource)context.lookup(dataSourceName);
        }
        catch (NamingException e) {
            throw new DataSourceNotFoundException("Unable to find data source for given name: " + dataSourceName, e);
        }
    }
}

