/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.data.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.arquillian.ape.rdbms.core.data.descriptor.ResourceDescriptor;
import org.arquillian.ape.rdbms.core.exception.InvalidResourceLocation;
import org.arquillian.ape.rdbms.core.metadata.MetadataExtractor;
import org.arquillian.ape.rdbms.core.metadata.MetadataProcessingException;
import org.arquillian.ape.rdbms.core.util.Strings;
import org.jboss.arquillian.test.spi.TestClass;

public abstract class ResourceProvider<T extends ResourceDescriptor<?>> {
    protected final MetadataExtractor metadataExtractor;
    protected final Class<? extends Annotation> resourceAnnotation;

    public ResourceProvider(Class<? extends Annotation> resourceAnnotation, MetadataExtractor metadataExtractor) {
        this.resourceAnnotation = resourceAnnotation;
        this.metadataExtractor = metadataExtractor;
    }

    public Collection<T> getDescriptors(TestClass testClass) {
        ArrayList<T> descriptors = new ArrayList<T>();
        for (Method testMethod : testClass.getMethods(this.resourceAnnotation)) {
            descriptors.addAll(this.getDescriptorsDefinedFor(testMethod));
        }
        descriptors.addAll(this.obtainClassLevelDescriptor(testClass.getAnnotation(this.resourceAnnotation)));
        return descriptors;
    }

    public Collection<T> getDescriptorsDefinedFor(Method testMethod) {
        ArrayList<T> descriptors = new ArrayList<T>();
        for (String dataFileName : this.getResourceFileNames(testMethod)) {
            T descriptor = this.createDescriptor(dataFileName);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public abstract Collection<String> getResourceFileNames(Method var1);

    protected abstract T createDescriptor(String var1);

    protected abstract String defaultLocation();

    protected abstract String defaultFileName();

    protected List<T> obtainClassLevelDescriptor(Annotation classLevelAnnotation) {
        if (classLevelAnnotation == null) {
            return Collections.emptyList();
        }
        ArrayList<T> descriptors = new ArrayList<T>();
        try {
            String[] values = (String[])classLevelAnnotation.annotationType().getMethod("value", new Class[0]).invoke((Object)classLevelAnnotation, new Object[0]);
            ArrayList<String> resources = new ArrayList<String>(Arrays.asList(values));
            if (resources.isEmpty() || Strings.isEmpty((String)resources.get(0))) {
                String defaultFileName = this.defaultFileName();
                resources.clear();
                resources.add(defaultFileName);
            }
            for (String dataFileName : resources) {
                descriptors.add(this.createDescriptor(dataFileName));
            }
        }
        catch (Exception e) {
            throw new MetadataProcessingException("Unable to evaluate annotation value", e);
        }
        return descriptors;
    }

    protected String defaultFolder() {
        String defaultLocation = this.defaultLocation();
        if (!defaultLocation.endsWith("/")) {
            defaultLocation = defaultLocation + "/";
        }
        return defaultLocation;
    }

    protected String determineLocation(String location) {
        if (this.existsInDefaultLocation(location)) {
            return this.defaultFolder() + location;
        }
        if (!this.existsInGivenLocation(location)) {
            throw new InvalidResourceLocation("Unable to locate " + location + ". File does not exist also in default location " + this.defaultLocation());
        }
        return location;
    }

    protected boolean existsInGivenLocation(String location) {
        try {
            URL url = this.load(location);
            if (url == null) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidResourceLocation("Unable to open resource file in " + location, e);
        }
        return true;
    }

    protected boolean existsInDefaultLocation(String location) {
        String defaultLocation = this.defaultFolder() + location;
        return this.existsInGivenLocation(defaultLocation);
    }

    private URL load(String resourceLocation) throws URISyntaxException {
        return Thread.currentThread().getContextClassLoader().getResource(resourceLocation);
    }
}

