/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.data.descriptor;

import java.util.EnumSet;

public enum Format {
    DTD("dtd"),
    XML("xml"),
    EXCEL("xls"),
    YAML("yml"),
    JSON("json"),
    INLINE_SQL("-inline-"),
    SQL_SCRIPT("sql"),
    UNSUPPORTED("-none-");

    private static final EnumSet<Format> NOT_REAL_FILE_TYPES;
    private final String fileExtension;

    private Format(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public static Format inferFromFile(String fileName) {
        EnumSet<Format> validFormats = EnumSet.complementOf(NOT_REAL_FILE_TYPES);
        for (Format format : validFormats) {
            if (!fileName.endsWith(format.fileExtension)) continue;
            return format;
        }
        return UNSUPPORTED;
    }

    public static boolean isFileType(Format format) {
        return EnumSet.complementOf(NOT_REAL_FILE_TYPES).contains((Object)format);
    }

    public String extension() {
        return this.fileExtension;
    }

    static {
        NOT_REAL_FILE_TYPES = EnumSet.of(UNSUPPORTED, INLINE_SQL);
    }
}

