/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

final class ReflectionHelper {
    private ReflectionHelper() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static List<Field> getAccessibleFields(final Class<?> source) {
        return AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Field field : source.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    foundFields.add(field);
                }
                return foundFields;
            }
        });
    }
}

