/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.core.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.arquillian.ape.rdbms.core.exception.PersistenceExtensionInitializationException;

public class PropertiesSerializer {
    private final String prefix;

    public PropertiesSerializer() {
        this("");
    }

    public PropertiesSerializer(String prefix) {
        this.prefix = prefix;
    }

    public ByteArrayOutputStream serializeToProperties(Map<String, String> properties) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                output.write(this.serializeAsProperty(entry).getBytes());
            }
        }
        catch (IOException e) {
            throw new PersistenceExtensionInitializationException("Unable to serialize dbunit properties", e);
        }
        return output;
    }

    private String serializeAsProperty(Map.Entry<String, String> entry) {
        String sb;
        String serializedAsProperty = sb = this.prefix + entry.getKey() + "=" + entry.getValue().replace("\\", "\\\\") + '\n';
        return serializedAsProperty;
    }
}

