/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.nosql.mongodb;

import com.lordofthejars.nosqlunit.mongodb.DefaultInsertionStrategy;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConnectionCallback;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.core.DataSetLoader;
import org.arquillian.ape.nosql.NoSqlPopulatorService;
import org.arquillian.ape.nosql.mongodb.MongoDb;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDbPopulatorService
implements NoSqlPopulatorService<MongoDb> {
    private MongoClient mongoClient;
    private MongoDatabase database;

    MongoDbPopulatorService() {
    }

    public void connect(String host, int port, String database, Map<String, Object> customOptions) {
        if (database == null) {
            database = "test";
        }
        this.mongoClient = new MongoClient(host, port);
        this.database = this.mongoClient.getDatabase(database);
    }

    public void connect(URI uri, String database, Map<String, Object> customOptions) {
        if (database == null) {
            database = "test";
        }
        this.mongoClient = new MongoClient(new MongoClientURI(uri.toString()));
        this.database = this.mongoClient.getDatabase(database);
    }

    public void disconnect() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public void execute(List<String> resources) {
        DefaultInsertionStrategy mongoDBInsertionStrategy = new DefaultInsertionStrategy();
        resources.stream().map(DataSetLoader::resolve).forEach(dataset -> {
            try {
                mongoDBInsertionStrategy.insert(new MongoDbConnectionCallback(){

                    public MongoDatabase db() {
                        return MongoDbPopulatorService.this.database;
                    }

                    public MongoClient mongoClient() {
                        return MongoDbPopulatorService.this.mongoClient;
                    }
                }, dataset);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void clean() {
        MongoIterable listCollectionNames = this.database.listCollectionNames();
        for (String collectionName : listCollectionNames) {
            if (!this.isNotASystemCollection(collectionName)) continue;
            MongoCollection dbCollection = this.database.getCollection(collectionName);
            dbCollection.deleteMany((Bson)new Document());
        }
    }

    private boolean isNotASystemCollection(String collectionName) {
        return !collectionName.startsWith("system.");
    }

    public Class<MongoDb> getPopulatorAnnotation() {
        return MongoDb.class;
    }
}

