/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.nosql.couchdb;

import com.lordofthejars.nosqlunit.couchdb.DefaultCouchDbInsertionStrategy;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.core.DataSetLoader;
import org.arquillian.ape.nosql.NoSqlPopulatorService;
import org.arquillian.ape.nosql.couchdb.CouchDb;
import org.arquillian.ape.nosql.couchdb.CouchDbOptions;
import org.ektorp.CouchDbConnector;
import org.ektorp.http.HttpClient;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbInstance;

class CouchDbPopulatorService
implements NoSqlPopulatorService<CouchDb> {
    private CouchDbConnector couchDbConnector;

    CouchDbPopulatorService() {
    }

    public void connect(String host, int port, String database, Map<String, Object> customOptions) {
        this.couchDbConnector = this.couchDbConnector(this.createCouchDbClusterUri(host, port), database, customOptions);
    }

    public void connect(URI uri, String database, Map<String, Object> customOptions) {
        this.couchDbConnector = this.couchDbConnector(uri.toString(), database, customOptions);
    }

    private String createCouchDbClusterUri(String host, int port) {
        if (port > 0) {
            return "http://" + host + ":" + port;
        }
        return "http://" + host;
    }

    public CouchDbConnector couchDbConnector(String uri, String database, Map<String, Object> configuration) {
        StdHttpClient.Builder httpBuilder = this.couchDbHttpClient(uri, configuration);
        return this.couchDbConnector(database, httpBuilder);
    }

    private CouchDbConnector couchDbConnector(String database, StdHttpClient.Builder httpBuilder) {
        StdCouchDbInstance dbInstance = new StdCouchDbInstance(httpBuilder.build());
        return dbInstance.createConnector(database, true);
    }

    private StdHttpClient.Builder couchDbHttpClient(String uri, Map<String, Object> configuration) {
        StdHttpClient.Builder httpBuilder = new StdHttpClient.Builder();
        try {
            httpBuilder.url(uri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        CouchDbOptions couchDbOptions = new CouchDbOptions(configuration);
        couchDbOptions.configure(httpBuilder);
        return httpBuilder;
    }

    public void disconnect() {
        if (this.couchDbConnector != null) {
            this.couchDbConnector.getConnection().shutdown();
        }
    }

    public void execute(List<String> resources) {
        DefaultCouchDbInsertionStrategy defaultCouchDbInsertionStrategy = new DefaultCouchDbInsertionStrategy();
        resources.stream().map(DataSetLoader::resolve).forEach(dataset -> {
            try {
                defaultCouchDbInsertionStrategy.insert(() -> this.couchDbConnector, dataset);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void clean() {
        if (this.couchDbConnector != null) {
            HttpClient connection = this.couchDbConnector.getConnection();
            RestTemplate restTemplate = new RestTemplate(connection);
            restTemplate.delete(this.couchDbConnector.path());
            this.couchDbConnector.createDatabaseIfNotExists();
        }
    }

    public Class<CouchDb> getPopulatorAnnotation() {
        return CouchDb.class;
    }
}

