/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.nosql.couchdb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.arquillian.ape.core.RunnerExpressionParser;
import org.arquillian.ape.nosql.couchdb.CouchDbConfiguration;
import org.ektorp.http.StdHttpClient;

public class CouchDbOptions
implements Map<String, Object> {
    static final String USERNAME = "username";
    static final String PASSWORD = "password";
    static final String CACHING = "caching";
    static final String ENABLE_SSL = "enableSsl";
    static final String RELAXED_SSL = "relaxedSsl";
    static final String SSL_FACTORY_SOCKET = "sslFactorySocket";
    private Map<String, Object> options = new HashMap<String, Object>();

    private CouchDbOptions() {
    }

    CouchDbOptions(Map<String, Object> options) {
        this.options.putAll(options);
    }

    public static CouchDbConfigurationOptions options() {
        return new CouchDbConfigurationOptions();
    }

    @Override
    public int size() {
        return this.options.size();
    }

    @Override
    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.options.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.options.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.options.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.options.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.options.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.options.putAll(m);
    }

    @Override
    public void clear() {
        this.options.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.options.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.options.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.options.entrySet();
    }

    void configure(StdHttpClient.Builder httpBuilder) {
        if (this.options.containsKey(USERNAME)) {
            httpBuilder.username((String)this.options.get(USERNAME));
        }
        if (this.options.containsKey(PASSWORD)) {
            httpBuilder.password((String)this.options.get(PASSWORD));
        }
        if (this.options.containsKey(CACHING)) {
            httpBuilder.caching(((Boolean)this.options.get(CACHING)).booleanValue());
        } else {
            httpBuilder.caching(true);
        }
        if (this.options.containsKey(ENABLE_SSL)) {
            httpBuilder.enableSSL(((Boolean)this.options.get(ENABLE_SSL)).booleanValue());
        }
        if (this.options.containsKey(RELAXED_SSL)) {
            httpBuilder.relaxedSSLSettings(((Boolean)this.options.get(RELAXED_SSL)).booleanValue());
        }
        if (this.options.containsKey(SSL_FACTORY_SOCKET)) {
            httpBuilder.sslSocketFactory((SSLSocketFactory)this.options.get(SSL_FACTORY_SOCKET));
        }
    }

    public static CouchDbOptions from(CouchDbConfiguration couchDbConfiguration) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (!couchDbConfiguration.username().isEmpty()) {
            options.put(USERNAME, RunnerExpressionParser.parseExpressions((String)couchDbConfiguration.username()));
        }
        if (!couchDbConfiguration.password().isEmpty()) {
            options.put(PASSWORD, RunnerExpressionParser.parseExpressions((String)couchDbConfiguration.password()));
        }
        if (!couchDbConfiguration.caching().isEmpty()) {
            options.put(CACHING, Boolean.parseBoolean(RunnerExpressionParser.parseExpressions((String)couchDbConfiguration.caching())));
        }
        if (!couchDbConfiguration.enableSsl().isEmpty()) {
            options.put(ENABLE_SSL, Boolean.parseBoolean(RunnerExpressionParser.parseExpressions((String)couchDbConfiguration.enableSsl())));
        }
        if (!couchDbConfiguration.relaxedSsl().isEmpty()) {
            options.put(RELAXED_SSL, Boolean.parseBoolean(RunnerExpressionParser.parseExpressions((String)couchDbConfiguration.relaxedSsl())));
        }
        return new CouchDbOptions(options);
    }

    public static class CouchDbConfigurationOptions {
        private CouchDbOptions couchDbOptions = new CouchDbOptions();

        private CouchDbConfigurationOptions() {
        }

        public CouchDbConfigurationOptions username(String username) {
            this.couchDbOptions.put(CouchDbOptions.USERNAME, (Object)username);
            return this;
        }

        public CouchDbConfigurationOptions password(String password) {
            this.couchDbOptions.put(CouchDbOptions.PASSWORD, (Object)password);
            return this;
        }

        public CouchDbConfigurationOptions caching(Boolean caching) {
            this.couchDbOptions.put(CouchDbOptions.CACHING, (Object)caching);
            return this;
        }

        public CouchDbConfigurationOptions enableSsl(Boolean enableSsl) {
            this.couchDbOptions.put(CouchDbOptions.ENABLE_SSL, (Object)enableSsl);
            return this;
        }

        public CouchDbConfigurationOptions relaxedSsl(Boolean relaxedSsl) {
            this.couchDbOptions.put(CouchDbOptions.RELAXED_SSL, (Object)relaxedSsl);
            return this;
        }

        public CouchDbConfigurationOptions sslFactorySocket(SSLSocketFactory sslSocketFactory) {
            this.couchDbOptions.put(CouchDbOptions.SSL_FACTORY_SOCKET, (Object)sslSocketFactory);
            return this;
        }

        public CouchDbOptions build() {
            return this.couchDbOptions;
        }
    }
}

