/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.nosql.couchdb;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.arquillian.ape.api.MetadataExtractor;
import org.arquillian.ape.nosql.NoSqlDeclarativeSupport;
import org.arquillian.ape.nosql.NoSqlPopulator;
import org.arquillian.ape.nosql.NoSqlPopulatorService;
import org.arquillian.ape.nosql.couchdb.CouchDb;
import org.arquillian.ape.nosql.couchdb.CouchDbConfiguration;
import org.arquillian.ape.nosql.couchdb.CouchDbOptions;
import org.arquillian.ape.nosql.couchdb.CouchDbPopulatorService;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class CouchDbDeclarativeSupport
extends NoSqlDeclarativeSupport {
    protected CouchDbDeclarativeSupport() {
        super(new NoSqlPopulator((NoSqlPopulatorService)new CouchDbPopulatorService()));
    }

    void connect(@Observes BeforeClass beforeClass) {
        this.configure(beforeClass.getTestClass());
    }

    void populate(@Observes Before before) {
        this.populate(before.getTestClass(), before.getTestMethod());
    }

    void cleanBefore(@Observes(precedence=10) Before before) {
        this.clean(before.getTestClass(), before.getTestMethod(), false);
    }

    void cleanAfter(@Observes After after) {
        this.clean(after.getTestClass(), after.getTestMethod(), true);
    }

    protected Map<String, Object> getConfiguration(TestClass testClass) {
        MetadataExtractor metadataExtractor = new MetadataExtractor(testClass);
        Optional<Annotation> redisConfigurationOptional = Optional.ofNullable(metadataExtractor.using(CouchDbConfiguration.class).getAnnotationOnClassLevel());
        HashMap<String, Object> options = new HashMap<String, Object>();
        redisConfigurationOptional.ifPresent(redisConfiguration -> options.putAll(CouchDbOptions.from(redisConfiguration)));
        return options;
    }

    protected Class<? extends Annotation> getPopulatorAnnotation() {
        return CouchDb.class;
    }
}

