/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.junit.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.arquillian.ape.spi.Populator;
import org.arquillian.ape.spi.PopulatorService;

class Reflection {
    private Reflection() {
    }

    public static boolean isClassWithAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        return AccessController.doPrivileged(() -> {
            boolean annotationPresent = false;
            for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                if (!nextSource.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return annotationPresent;
        });
    }

    public static final List<Field> getAllFieldsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = clazz;
        while (current.getSuperclass() != null) {
            fields.addAll(Arrays.stream(current.getDeclaredFields()).peek(field -> field.setAccessible(true)).filter(field -> field.isAnnotationPresent(annotation)).collect(Collectors.toList()));
            current = current.getSuperclass();
        }
        return fields;
    }

    public static final Optional<Field> getFieldAnnotedWith(List<Field> fields, Class<? extends Annotation> annotation) {
        return fields.stream().filter(field -> field.isAnnotationPresent(annotation)).findFirst();
    }

    public static final void instantiateServiceAndPopulatorAndInject(Object testInstance, Field field, Class<? extends PopulatorService> serviceClass, Class<? extends Populator> populatorClass) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor<? extends PopulatorService> serviceConstructor = serviceClass.getDeclaredConstructor(new Class[0]);
        serviceConstructor.setAccessible(true);
        PopulatorService service = serviceConstructor.newInstance(new Object[0]);
        Constructor<?> populatorConstructor = populatorClass.getDeclaredConstructors()[0];
        populatorConstructor.setAccessible(true);
        Populator populator = (Populator)populatorConstructor.newInstance(service);
        field.set(testInstance, populator);
    }
}

