/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.junit.rule;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.arquillian.ape.api.DeclarativeSupport;
import org.arquillian.ape.spi.junit.rule.JUnitRuleSupport;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class DeclarativeArquillianPersistenceRule
implements MethodRule {
    private static final Map<Class<? extends Annotation>, DeclarativeSupport> populators = new HashMap<Class<? extends Annotation>, DeclarativeSupport>();

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestClass testClass = new TestClass(target.getClass());
                this.run(declarativeSupport -> declarativeSupport.configure(testClass));
                this.run(declarativeSupport -> declarativeSupport.clean(testClass, method.getMethod(), false));
                this.run(declarativeSupport -> declarativeSupport.populate(testClass, method.getMethod()));
                base.evaluate();
                this.run(declarativeSupport -> declarativeSupport.clean(testClass, method.getMethod(), true));
            }

            private void run(Consumer<DeclarativeSupport> consumer) {
                Collection values = populators.values();
                for (DeclarativeSupport declarativeSupport : values) {
                    consumer.accept(declarativeSupport);
                }
            }
        };
    }

    static {
        ServiceLoader<JUnitRuleSupport> serviceLoader = ServiceLoader.load(JUnitRuleSupport.class);
        StreamSupport.stream(serviceLoader.spliterator(), false).forEach(service -> populators.put(service.populatorAnnotation(), service.declarativeSupport()));
    }
}

