/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.junit.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.arquillian.ape.junit.rule.Reflection;
import org.arquillian.ape.spi.Populator;
import org.arquillian.ape.spi.PopulatorService;
import org.arquillian.ape.spi.junit.rule.JUnitRuleSupport;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ArquillianPersistenceRule
implements MethodRule {
    private static final Map<Class<? extends Annotation>, PopulatorInfo> populators = new HashMap<Class<? extends Annotation>, PopulatorInfo>();

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                List<Field> allFieldsAnnotatedWith = Reflection.getAllFieldsAnnotatedWith(target.getClass(), ArquillianResource.class);
                Set entries = populators.entrySet();
                for (Map.Entry serviceEntry : entries) {
                    Optional<Field> fieldAnnotedWithPopulatorAnnotation = Reflection.getFieldAnnotedWith(allFieldsAnnotatedWith, (Class)serviceEntry.getKey());
                    if (!fieldAnnotedWithPopulatorAnnotation.isPresent()) continue;
                    Reflection.instantiateServiceAndPopulatorAndInject(target, fieldAnnotedWithPopulatorAnnotation.get(), ((PopulatorInfo)serviceEntry.getValue()).populatorService, ((PopulatorInfo)serviceEntry.getValue()).populator);
                }
                base.evaluate();
            }
        };
    }

    static {
        ServiceLoader<JUnitRuleSupport> serviceLoader = ServiceLoader.load(JUnitRuleSupport.class);
        StreamSupport.stream(serviceLoader.spliterator(), false).forEach(service -> populators.put(service.populatorAnnotation(), new PopulatorInfo(service.populatotService(), service.populator())));
    }

    static class PopulatorInfo {
        Class<? extends PopulatorService> populatorService;
        Class<? extends Populator> populator;

        PopulatorInfo(Class<? extends PopulatorService> populatorService, Class<? extends Populator> populator) {
            this.populatorService = populatorService;
            this.populator = populator;
        }
    }
}

