/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.loader;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.meta.Slot;
import org.archguard.scanner.core.Analyser;
import org.archguard.scanner.core.AnalyserSpec;
import org.archguard.scanner.core.context.Context;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0012H\u0002J\f\u0010\u0019\u001a\u00020\u0004*\u00020\u0012H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0012H\u0002J\f\u0010\u001b\u001a\u00020\u0017*\u00020\u0012H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/archguard/scanner/ctl/loader/AnalyserLoader;", "", "()V", "folder", "", "installPath", "Ljava/nio/file/Path;", "getInstallPath", "()Ljava/nio/file/Path;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rootPath", "load", "Lorg/archguard/scanner/core/Analyser;", "Lorg/archguard/scanner/core/context/Context;", "context", "spec", "Lorg/archguard/scanner/core/AnalyserSpec;", "loadSlot", "Lorg/archguard/meta/Slot;", "Lorg/archguard/scanner/core/SlotSpec;", "copyFrom", "", "download", "getFullClassName", "getLocalPath", "install", "isInstalled", "", "scanner_cli"})
@SourceDebugExtension(value={"SMAP\nAnalyserLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyserLoader.kt\norg/archguard/scanner/ctl/loader/AnalyserLoader\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n17#2,6:102\n1#3:108\n*S KotlinDebug\n*F\n+ 1 AnalyserLoader.kt\norg/archguard/scanner/ctl/loader/AnalyserLoader\n*L\n52#1:102,6\n*E\n"})
public final class AnalyserLoader {
    @NotNull
    public static final AnalyserLoader INSTANCE = new AnalyserLoader();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
    private static final Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
    @NotNull
    private static final String folder = "dependencies/analysers";
    @NotNull
    private static final Path installPath;

    private AnalyserLoader() {
    }

    @NotNull
    public final Path getInstallPath() {
        return installPath;
    }

    private final boolean isInstalled(AnalyserSpec $this$isInstalled) {
        boolean bl;
        logger.debug("workspace path: " + rootPath);
        logger.debug("analyser install path: " + installPath);
        File[] fileArray = installPath.toFile().listFiles((arg_0, arg_1) -> AnalyserLoader.isInstalled$lambda$0($this$isInstalled, arg_0, arg_1));
        boolean it = bl = !(fileArray == null || fileArray.length == 0);
        boolean bl2 = false;
        if (it) {
            logger.debug("analyser: " + $this$isInstalled.getIdentifier() + " - [" + $this$isInstalled.getVersion() + "] is installed");
        } else {
            logger.debug("analyser: " + $this$isInstalled.getIdentifier() + " - [" + $this$isInstalled.getVersion() + "] is not installed");
        }
        return bl;
    }

    private final void install(AnalyserSpec $this$install) {
        if (StringsKt.startsWith$default((String)$this$install.getHost(), (String)"/", (boolean)false, (int)2, null)) {
            this.copyFrom($this$install);
        } else if (StringsKt.startsWith$default((String)$this$install.getHost(), (String)"http", (boolean)false, (int)2, null)) {
            this.download($this$install);
        } else {
            throw new IllegalArgumentException("please use absolute path or http url to install the analyser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void download(AnalyserSpec $this$download) {
        URL sourceUrl = new URL($this$download.getHost() + '/' + $this$download.getJar());
        Path targetJarPath = this.getLocalPath($this$download);
        logger.debug("analyser is configured as url, downloading to installation path...");
        logger.debug("| {} -> {} |", (Object)sourceUrl, (Object)targetJarPath);
        logger.debug("downloading...");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Closeable closeable = sourceUrl.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(it, targetJarPath, copyOptionArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long cost = System.currentTimeMillis() - start$iv;
        logger.debug("downloading finished in " + cost + " ms");
    }

    private final void copyFrom(AnalyserSpec $this$copyFrom) {
        File sourceJarFile = Paths.get($this$copyFrom.getHost(), new String[0]).resolve($this$copyFrom.getJar()).toFile();
        File targetJarFile = this.getLocalPath($this$copyFrom).toFile();
        logger.debug("analyser is configured as absolute path, copying to installation path...");
        logger.debug("| {} -> {} |", (Object)sourceJarFile, (Object)targetJarFile);
        Intrinsics.checkNotNullExpressionValue((Object)sourceJarFile, (String)"sourceJarFile");
        Intrinsics.checkNotNullExpressionValue((Object)targetJarFile, (String)"targetJarFile");
        FilesKt.copyTo$default((File)sourceJarFile, (File)targetJarFile, (boolean)false, (int)0, (int)6, null);
    }

    private final String getFullClassName(AnalyserSpec $this$getFullClassName) {
        if (StringsKt.contains$default((CharSequence)$this$getFullClassName.getClassName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            return $this$getFullClassName.getClassName();
        }
        return "org.archguard.scanner.analyser." + $this$getFullClassName.getClassName();
    }

    private final Path getLocalPath(AnalyserSpec $this$getLocalPath) {
        Path path;
        Path it = path = rootPath.resolve(folder);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        Path folderPath = path;
        Path path2 = folderPath.resolve($this$getLocalPath.getJar());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"folderPath.resolve(jar)");
        return path2;
    }

    @NotNull
    public final Analyser<Context> load(@NotNull Context context, @NotNull AnalyserSpec spec) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (!this.isInstalled(spec)) {
            this.install(spec);
        }
        URL jarUrl = this.getLocalPath(spec).toUri().toURL();
        Object object = new URL[]{jarUrl};
        URLClassLoader cl = new URLClassLoader((URL[])object, this.getClass().getClassLoader());
        Object[] objectArray = new Object[]{context};
        object = Class.forName(this.getFullClassName(spec), true, cl).getDeclaredConstructors()[0].newInstance(objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.archguard.scanner.core.Analyser<org.archguard.scanner.core.context.Context>");
        return (Analyser)object;
    }

    @NotNull
    public final Slot loadSlot(@NotNull AnalyserSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (!this.isInstalled(spec)) {
            this.install(spec);
        }
        URL jarUrl = this.getLocalPath(spec).toUri().toURL();
        Object object = new URL[]{jarUrl};
        URLClassLoader cl = new URLClassLoader((URL[])object, this.getClass().getClassLoader());
        object = Class.forName(this.getFullClassName(spec), true, cl).getDeclaredConstructors()[0].newInstance(new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.archguard.meta.Slot");
        return (Slot)object;
    }

    private static final boolean isInstalled$lambda$0(AnalyserSpec $this_isInstalled, File file, String name) {
        Intrinsics.checkNotNullParameter((Object)$this_isInstalled, (String)"$this_isInstalled");
        return Intrinsics.areEqual((Object)name, (Object)$this_isInstalled.getJar());
    }

    static {
        Path path = rootPath.resolve(folder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootPath.resolve(folder)");
        installPath = path;
    }
}

