/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.client;

import chapi.domain.core.CodeDataStruct;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.rule.core.Issue;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.archguard.scanner.core.estimate.LanguageEstimate;
import org.archguard.scanner.core.git.ChangeEntry;
import org.archguard.scanner.core.git.CommitLog;
import org.archguard.scanner.core.git.GitLogs;
import org.archguard.scanner.core.git.PathChangeCount;
import org.archguard.scanner.core.openapi.ApiCollection;
import org.archguard.scanner.core.sca.CompositionDependency;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\u0016\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0016J\u0016\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\fH\u0016J\u0016\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0016J\u0016\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fH\u0016J\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0016J\u0016\u0010 \u001a\u00020\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\fH\u0016J\u0016\u0010#\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\fH\u0016J'\u0010&\u001a\u00020\n\"\u0006\b\u0000\u0010'\u0018\u00012\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\f2\u0006\u0010)\u001a\u00020\u0003H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/archguard/scanner/ctl/client/ArchGuardCsvClient;", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "systemId", "", "(Ljava/lang/String;)V", "csvMapper", "Lcom/fasterxml/jackson/dataformat/csv/CsvMapper;", "buildFileName", "topic", "saveApi", "", "apis", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "saveDataStructure", "codes", "Lchapi/domain/core/CodeDataStruct;", "saveDependencies", "dependencies", "Lorg/archguard/scanner/core/sca/CompositionDependency;", "saveDiffs", "calls", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "saveEstimates", "estimates", "Lorg/archguard/scanner/core/estimate/LanguageEstimate;", "saveGitLogs", "gitLogs", "Lorg/archguard/scanner/core/git/GitLogs;", "saveOpenApi", "collections", "Lorg/archguard/scanner/core/openapi/ApiCollection;", "saveRelation", "records", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "saveRuleIssues", "issues", "Lorg/archguard/rule/core/Issue;", "writeCsvFile", "T", "data", "fileName", "scanner_cli"})
@SourceDebugExtension(value={"SMAP\nArchGuardCsvClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchGuardCsvClient.kt\norg/archguard/scanner/ctl/client/ArchGuardCsvClient\n*L\n1#1,70:1\n24#1,7:71\n24#1,7:78\n24#1,7:85\n24#1,7:92\n24#1,7:99\n24#1,7:106\n24#1,7:113\n24#1,7:120\n24#1,7:127\n24#1,7:134\n24#1,7:141\n*S KotlinDebug\n*F\n+ 1 ArchGuardCsvClient.kt\norg/archguard/scanner/ctl/client/ArchGuardCsvClient\n*L\n33#1:71,7\n37#1:78,7\n41#1:85,7\n45#1:92,7\n46#1:99,7\n47#1:106,7\n51#1:113,7\n55#1:120,7\n59#1:127,7\n63#1:134,7\n67#1:141,7\n*E\n"})
public final class ArchGuardCsvClient
implements ArchGuardClient {
    @NotNull
    private final String systemId;
    @NotNull
    private final CsvMapper csvMapper;

    /*
     * WARNING - void declaration
     */
    public ArchGuardCsvClient(@NotNull String systemId) {
        void $this$csvMapper_u24lambda_u240;
        CsvMapper csvMapper;
        Intrinsics.checkNotNullParameter(systemId, "systemId");
        this.systemId = systemId;
        CsvMapper csvMapper2 = csvMapper = new CsvMapper();
        ArchGuardCsvClient archGuardCsvClient = this;
        boolean bl = false;
        $this$csvMapper_u24lambda_u240.registerModule(new KotlinModule.Builder().build());
        archGuardCsvClient.csvMapper = csvMapper;
    }

    private final String buildFileName(String topic) {
        return this.systemId + '_' + topic + ".csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final /* synthetic */ <T> void writeCsvFile(List<? extends T> data2, String fileName) {
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName);
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            this.csvMapper.writer(this.csvMapper.schemaFor(Object.class).withHeader()).writeValues(writer).writeAll((Collection)data2).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart(1);
            CloseableKt.closeFinally(closeable, throwable);
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveDataStructure(@NotNull List<CodeDataStruct> codes) {
        Intrinsics.checkNotNullParameter(codes, "codes");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("codes");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(CodeDataStruct.class).withHeader()).writeValues(writer$iv).writeAll((Collection)codes).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveApi(@NotNull List<ContainerService> apis) {
        Intrinsics.checkNotNullParameter(apis, "apis");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("apis");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(ContainerService.class).withHeader()).writeValues(writer$iv).writeAll((Collection)apis).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveRelation(@NotNull List<CodeDatabaseRelation> records) {
        Intrinsics.checkNotNullParameter(records, "records");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("databases");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(CodeDatabaseRelation.class).withHeader()).writeValues(writer$iv).writeAll((Collection)records).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveGitLogs(@NotNull List<GitLogs> gitLogs) {
        List<Object> data$iv;
        ArchGuardCsvClient this_$iv;
        boolean bl;
        Object writer$iv2;
        Intrinsics.checkNotNullParameter(gitLogs, "gitLogs");
        ArchGuardCsvClient archGuardCsvClient = this;
        List<CommitLog> list = gitLogs.get(0).getCommitLog();
        String fileName$iv = this.buildFileName("gitlogs-commit");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            writer$iv2 = (FileWriter)closeable;
            bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(CommitLog.class).withHeader()).writeValues((Writer)writer$iv2).writeAll((Collection)data$iv).close();
            writer$iv2 = Unit.INSTANCE;
        }
        catch (Throwable writer$iv2) {
            throwable = writer$iv2;
            throw writer$iv2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this_$iv = this;
        data$iv = gitLogs.get(0).getChangeEntry();
        fileName$iv = this.buildFileName("gitlogs-change-entry");
        $i$f$writeCsvFile = false;
        closeable = new FileWriter(fileName$iv);
        throwable = null;
        try {
            writer$iv2 = (FileWriter)closeable;
            bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(ChangeEntry.class).withHeader()).writeValues((Writer)writer$iv2).writeAll((Collection)data$iv).close();
            writer$iv2 = Unit.INSTANCE;
        }
        catch (Throwable writer$iv3) {
            throwable = writer$iv3;
            throw writer$iv3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this_$iv = this;
        data$iv = gitLogs.get(0).getPathChangeCount();
        fileName$iv = this.buildFileName("gitlogs-change-count");
        $i$f$writeCsvFile = false;
        closeable = new FileWriter(fileName$iv);
        throwable = null;
        try {
            writer$iv2 = (FileWriter)closeable;
            bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(PathChangeCount.class).withHeader()).writeValues((Writer)writer$iv2).writeAll((Collection)data$iv).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveDiffs(@NotNull List<ChangedCall> calls) {
        Intrinsics.checkNotNullParameter(calls, "calls");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("diff-changes");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(ChangedCall.class).withHeader()).writeValues(writer$iv).writeAll((Collection)calls).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveDependencies(@NotNull List<CompositionDependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, "dependencies");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("sca-dependencies");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(CompositionDependency.class).withHeader()).writeValues(writer$iv).writeAll((Collection)dependencies).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveRuleIssues(@NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, "issues");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("issues");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(Issue.class).withHeader()).writeValues(writer$iv).writeAll((Collection)issues).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveEstimates(@NotNull List<LanguageEstimate> estimates) {
        Intrinsics.checkNotNullParameter(estimates, "estimates");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("estimates");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(LanguageEstimate.class).withHeader()).writeValues(writer$iv).writeAll((Collection)estimates).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void saveOpenApi(@NotNull List<ApiCollection> collections) {
        Intrinsics.checkNotNullParameter(collections, "collections");
        ArchGuardCsvClient archGuardCsvClient = this;
        String fileName$iv = this.buildFileName("openapi");
        boolean $i$f$writeCsvFile = false;
        Closeable closeable = new FileWriter(fileName$iv);
        Throwable throwable = null;
        try {
            void this_$iv;
            FileWriter writer$iv = (FileWriter)closeable;
            boolean bl = false;
            this_$iv.csvMapper.writer(this_$iv.csvMapper.schemaFor(ApiCollection.class).withHeader()).writeValues(writer$iv).writeAll((Collection)collections).close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

