/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.ByteArrayInput;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0082\bJ\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0012\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010'\u001a\u00020\u0006J\b\u0010(\u001a\u00020\u0006H\u0002J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010*\u001a\u00020\u0017H\u0002J\u0006\u0010+\u001a\u00020\u0017J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020-J\u0006\u0010/\u001a\u00020\u0006J\u0006\u00100\u001a\u00020\u000fJ\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006H\u0002R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "", "input", "Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)V", "currentId", "", "currentType", "eof", "", "getEof", "()Z", "pushBack", "pushBackHeader", "assertWireType", "", "expected", "checkLength", "length", "decode32", "format", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "decode64", "", "decodeSignedVarintInt", "decodeSignedVarintLong", "objectInput", "objectTaglessInput", "pushBackTag", "readByteArray", "", "readByteArrayNoTag", "readDouble", "", "readDoubleNoTag", "readFloat", "", "readFloatNoTag", "readInt", "readInt32NoTag", "readIntLittleEndian", "readLong", "readLongLittleEndian", "readLongNoTag", "readString", "", "readStringNoTag", "readTag", "skipElement", "updateIdAndType", "header", "kotlinx-serialization-protobuf"})
public final class ProtobufReader {
    @NotNull
    private final ByteArrayInput input;
    @JvmField
    public int currentId;
    @JvmField
    public int currentType;
    private boolean pushBack;
    private int pushBackHeader;

    public ProtobufReader(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.input = input;
        this.currentId = -1;
        this.currentType = -1;
    }

    public final boolean getEof() {
        return !this.pushBack && this.input.getAvailableBytes() == 0;
    }

    public final int readTag() {
        if (this.pushBack) {
            int n;
            this.pushBack = false;
            int previousHeader = this.currentId << 3 | this.currentType;
            int it = n = this.updateIdAndType(this.pushBackHeader);
            boolean bl = false;
            this.pushBackHeader = previousHeader;
            return n;
        }
        this.pushBackHeader = this.currentId << 3 | this.currentType;
        int header = (int)this.input.readVarint64(true);
        return this.updateIdAndType(header);
    }

    private final int updateIdAndType(int header) {
        int n;
        if (header == -1) {
            this.currentId = -1;
            this.currentType = -1;
            n = -1;
        } else {
            this.currentId = header >>> 3;
            this.currentType = header & 7;
            n = this.currentId;
        }
        return n;
    }

    public final void pushBackTag() {
        this.pushBack = true;
        int nextHeader = this.currentId << 3 | this.currentType;
        this.updateIdAndType(this.pushBackHeader);
        this.pushBackHeader = nextHeader;
    }

    public final void skipElement() {
        switch (this.currentType) {
            case 0: {
                this.readInt(ProtoIntegerType.DEFAULT);
                break;
            }
            case 1: {
                this.readLong(ProtoIntegerType.FIXED);
                break;
            }
            case 2: {
                this.readByteArray();
                break;
            }
            case 5: {
                this.readInt(ProtoIntegerType.FIXED);
                break;
            }
            default: {
                throw new ProtobufDecodingException("Unsupported start group or end group wire type: " + this.currentType);
            }
        }
    }

    private final void assertWireType(int expected) {
        boolean $i$f$assertWireType = false;
        if (this.currentType != expected) {
            throw new ProtobufDecodingException("Expected wire type " + expected + ", but found " + this.currentType);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readByteArray() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.readByteArrayNoTag();
    }

    @NotNull
    public final byte[] readByteArrayNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readExactNBytes(length);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayInput objectInput() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.objectTaglessInput();
    }

    @NotNull
    public final ByteArrayInput objectTaglessInput() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.slice(length);
    }

    public final int readInt(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 5 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode32(format);
    }

    public final int readInt32NoTag() {
        return ProtobufReader.decode32$default(this, null, 1, null);
    }

    public final long readLong(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 1 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode64(format);
    }

    public final long readLongNoTag() {
        return this.decode64(ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public final float readFloat() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 5;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    public final float readFloatNoTag() {
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    private final int readIntLittleEndian() {
        int result2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read() & 0xFF;
            result2 |= n << i * 8;
        }
        return result2;
    }

    private final long readLongLittleEndian() {
        long result2 = 0L;
        for (int i = 0; i < 8; ++i) {
            long l = this.input.read() & 0xFF;
            result2 |= l << i * 8;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final double readDouble() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 1;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    public final double readDoubleNoTag() {
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    @NotNull
    public final String readStringNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    private final void checkLength(int length) {
        if (length < 0) {
            throw new ProtobufDecodingException("Unexpected negative length: " + length);
        }
    }

    private final int decode32(ProtoIntegerType format) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                n = (int)this.input.readVarint64(false);
                break;
            }
            case 2: {
                n = this.decodeSignedVarintInt(this.input);
                break;
            }
            case 3: {
                n = this.readIntLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    static /* synthetic */ int decode32$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode32(protoIntegerType);
    }

    private final long decode64(ProtoIntegerType format) {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                l = this.input.readVarint64(false);
                break;
            }
            case 2: {
                l = this.decodeSignedVarintLong(this.input);
                break;
            }
            case 3: {
                l = this.readLongLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    static /* synthetic */ long decode64$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode64(protoIntegerType);
    }

    private final int decodeSignedVarintInt(ByteArrayInput input) {
        int raw = input.readVarint32();
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    private final long decodeSignedVarintLong(ByteArrayInput input) {
        long raw = input.readVarint64(false);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

